/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.taskmanager;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.instance.HardwareDescription;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.messages.json.ResourceIDDeserializer;
import org.apache.flink.runtime.rest.messages.json.ResourceIDSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.flink.util.Preconditions;

public class TaskManagerInfo
implements ResponseBody,
Serializable {
    public static final String FIELD_NAME_RESOURCE_ID = "id";
    public static final String FIELD_NAME_ADDRESS = "path";
    public static final String FIELD_NAME_DATA_PORT = "dataPort";
    public static final String FIELD_NAME_LAST_HEARTBEAT = "timeSinceLastHeartbeat";
    public static final String FIELD_NAME_NUMBER_SLOTS = "slotsNumber";
    public static final String FIELD_NAME_NUMBER_AVAILABLE_SLOTS = "freeSlots";
    public static final String FIELD_NAME_HARDWARE = "hardware";
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="id")
    @JsonSerialize(using=ResourceIDSerializer.class)
    private final ResourceID resourceId;
    @JsonProperty(value="path")
    private final String address;
    @JsonProperty(value="dataPort")
    private final int dataPort;
    @JsonProperty(value="timeSinceLastHeartbeat")
    private final long lastHeartbeat;
    @JsonProperty(value="slotsNumber")
    private final int numberSlots;
    @JsonProperty(value="freeSlots")
    private final int numberAvailableSlots;
    @JsonProperty(value="hardware")
    private final HardwareDescription hardwareDescription;

    @JsonCreator
    public TaskManagerInfo(@JsonDeserialize(using=ResourceIDDeserializer.class) @JsonProperty(value="id") ResourceID resourceId, @JsonProperty(value="path") String address, @JsonProperty(value="dataPort") int dataPort, @JsonProperty(value="timeSinceLastHeartbeat") long lastHeartbeat, @JsonProperty(value="slotsNumber") int numberSlots, @JsonProperty(value="freeSlots") int numberAvailableSlots, @JsonProperty(value="hardware") HardwareDescription hardwareDescription) {
        this.resourceId = (ResourceID)Preconditions.checkNotNull((Object)resourceId);
        this.address = (String)Preconditions.checkNotNull((Object)address);
        this.dataPort = dataPort;
        this.lastHeartbeat = lastHeartbeat;
        this.numberSlots = numberSlots;
        this.numberAvailableSlots = numberAvailableSlots;
        this.hardwareDescription = (HardwareDescription)Preconditions.checkNotNull((Object)hardwareDescription);
    }

    public ResourceID getResourceId() {
        return this.resourceId;
    }

    public String getAddress() {
        return this.address;
    }

    public int getDataPort() {
        return this.dataPort;
    }

    public long getLastHeartbeat() {
        return this.lastHeartbeat;
    }

    public int getNumberSlots() {
        return this.numberSlots;
    }

    public int getNumberAvailableSlots() {
        return this.numberAvailableSlots;
    }

    public HardwareDescription getHardwareDescription() {
        return this.hardwareDescription;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskManagerInfo that = (TaskManagerInfo)o;
        return this.dataPort == that.dataPort && this.lastHeartbeat == that.lastHeartbeat && this.numberSlots == that.numberSlots && this.numberAvailableSlots == that.numberAvailableSlots && Objects.equals(this.resourceId, that.resourceId) && Objects.equals(this.address, that.address) && Objects.equals(this.hardwareDescription, that.hardwareDescription);
    }

    public int hashCode() {
        return Objects.hash(this.resourceId, this.address, this.dataPort, this.lastHeartbeat, this.numberSlots, this.numberAvailableSlots, this.hardwareDescription);
    }
}

