/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DelegatingConfiguration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.runtime.metrics.scope.ScopeFormats;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricRegistryConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(MetricRegistryConfiguration.class);
    private static volatile MetricRegistryConfiguration defaultConfiguration;
    private static final Pattern reporterListPattern;
    private static final Pattern reporterClassPattern;
    private final ScopeFormats scopeFormats;
    private final char delimiter;
    private final List<Tuple2<String, Configuration>> reporterConfigurations;

    public MetricRegistryConfiguration(ScopeFormats scopeFormats, char delimiter, List<Tuple2<String, Configuration>> reporterConfigurations) {
        this.scopeFormats = (ScopeFormats)Preconditions.checkNotNull((Object)scopeFormats);
        this.delimiter = delimiter;
        this.reporterConfigurations = (List)Preconditions.checkNotNull(reporterConfigurations);
    }

    public ScopeFormats getScopeFormats() {
        return this.scopeFormats;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public List<Tuple2<String, Configuration>> getReporterConfigurations() {
        return this.reporterConfigurations;
    }

    public static MetricRegistryConfiguration fromConfiguration(Configuration configuration) {
        List<Tuple2<String, Configuration>> reporterConfigurations;
        char delim;
        ScopeFormats scopeFormats;
        try {
            scopeFormats = ScopeFormats.fromConfig(configuration);
        }
        catch (Exception e) {
            LOG.warn("Failed to parse scope format, using default scope formats", (Throwable)e);
            scopeFormats = ScopeFormats.fromConfig(new Configuration());
        }
        try {
            delim = configuration.getString(MetricOptions.SCOPE_DELIMITER).charAt(0);
        }
        catch (Exception e) {
            LOG.warn("Failed to parse delimiter, using default delimiter.", (Throwable)e);
            delim = '.';
        }
        String includedReportersString = configuration.getString(MetricOptions.REPORTERS_LIST, "");
        Set includedReporters = reporterListPattern.splitAsStream(includedReportersString).collect(Collectors.toSet());
        TreeSet<String> namedReporters = new TreeSet<String>(String::compareTo);
        for (String key : configuration.keySet()) {
            Matcher matcher;
            if (!key.startsWith("metrics.reporter.") || !(matcher = reporterClassPattern.matcher(key)).matches()) continue;
            String reporterName = matcher.group(1);
            if (includedReporters.isEmpty() || includedReporters.contains(reporterName)) {
                if (namedReporters.contains(reporterName)) {
                    LOG.warn("Duplicate class configuration detected for reporter {}.", (Object)reporterName);
                    continue;
                }
                namedReporters.add(reporterName);
                continue;
            }
            LOG.info("Excluding reporter {}, not configured in reporter list ({}).", (Object)reporterName, (Object)includedReportersString);
        }
        if (namedReporters.isEmpty()) {
            reporterConfigurations = Collections.emptyList();
        } else {
            reporterConfigurations = new ArrayList(namedReporters.size());
            for (String namedReporter : namedReporters) {
                DelegatingConfiguration delegatingConfiguration = new DelegatingConfiguration(configuration, "metrics.reporter." + namedReporter + '.');
                reporterConfigurations.add((Tuple2<String, Configuration>)Tuple2.of((Object)namedReporter, (Object)delegatingConfiguration));
            }
        }
        return new MetricRegistryConfiguration(scopeFormats, delim, reporterConfigurations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MetricRegistryConfiguration defaultMetricRegistryConfiguration() {
        if (defaultConfiguration != null) return defaultConfiguration;
        Class<MetricRegistryConfiguration> clazz = MetricRegistryConfiguration.class;
        synchronized (MetricRegistryConfiguration.class) {
            if (defaultConfiguration != null) return defaultConfiguration;
            defaultConfiguration = MetricRegistryConfiguration.fromConfiguration(new Configuration());
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultConfiguration;
        }
    }

    static {
        reporterListPattern = Pattern.compile("\\s*,\\s*");
        reporterClassPattern = Pattern.compile(Pattern.quote("metrics.reporter.") + "([\\S&&[^.]]*)\\." + Pattern.quote("class"));
    }
}

