/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nullable;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.instance.SharedSlot;
import org.apache.flink.runtime.instance.SimpleSlotContext;
import org.apache.flink.runtime.instance.Slot;
import org.apache.flink.runtime.instance.SlotSharingGroupId;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.SlotContext;
import org.apache.flink.runtime.jobmaster.SlotOwner;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;

public class SimpleSlot
extends Slot
implements LogicalSlot {
    private static final AtomicReferenceFieldUpdater<SimpleSlot, LogicalSlot.Payload> PAYLOAD_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SimpleSlot.class, LogicalSlot.Payload.class, "payload");
    private final CompletableFuture<?> releaseFuture = new CompletableFuture();
    private volatile LogicalSlot.Payload payload;
    private volatile Locality locality = Locality.UNCONSTRAINED;

    public SimpleSlot(SlotOwner owner, TaskManagerLocation location, int slotNumber, TaskManagerGateway taskManagerGateway) {
        this(owner, location, slotNumber, taskManagerGateway, null, null);
    }

    public SimpleSlot(SlotOwner owner, TaskManagerLocation location, int slotNumber, TaskManagerGateway taskManagerGateway, @Nullable SharedSlot parent, @Nullable AbstractID groupID) {
        super(parent != null ? parent.getSlotContext() : new SimpleSlotContext(NO_ALLOCATION_ID, location, slotNumber, taskManagerGateway), owner, slotNumber, parent, groupID);
    }

    public SimpleSlot(SlotContext slotContext, SlotOwner owner, int slotNumber) {
        this(slotContext, owner, slotNumber, null, null);
    }

    public SimpleSlot(SharedSlot parent, SlotOwner owner, int slotNumber, AbstractID groupID) {
        this(parent.getSlotContext(), owner, slotNumber, parent, groupID);
    }

    private SimpleSlot(SlotContext slotContext, SlotOwner owner, int slotNumber, @Nullable SharedSlot parent, @Nullable AbstractID groupID) {
        super(slotContext, owner, slotNumber, parent, groupID);
    }

    @Override
    public int getNumberLeaves() {
        return 1;
    }

    @Override
    public boolean tryAssignPayload(LogicalSlot.Payload payload) {
        Preconditions.checkNotNull((Object)payload);
        if (this.isCanceled()) {
            return false;
        }
        if (!PAYLOAD_UPDATER.compareAndSet(this, null, payload)) {
            return false;
        }
        if (this.isCanceled()) {
            this.payload = null;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public LogicalSlot.Payload getPayload() {
        return this.payload;
    }

    @Override
    public Locality getLocality() {
        return this.locality;
    }

    public void setLocality(Locality locality) {
        this.locality = locality;
    }

    @Override
    public CompletableFuture<?> releaseSlot(@Nullable Throwable cause) {
        if (!this.isCanceled()) {
            CompletableFuture<Object> terminationFuture;
            if (this.payload != null) {
                this.payload.fail(cause != null ? cause : new FlinkException("TaskManager was lost/killed: " + this.getTaskManagerLocation()));
                terminationFuture = this.payload.getTerminalStateFuture();
            } else {
                terminationFuture = CompletableFuture.completedFuture(null);
            }
            terminationFuture.whenComplete((ignored, throwable) -> {
                if (this.getParent() == null) {
                    if (this.markCancelled()) {
                        this.getOwner().returnAllocatedSlot(this).whenComplete((value, t) -> {
                            if (t != null) {
                                this.releaseFuture.completeExceptionally((Throwable)t);
                            } else {
                                this.releaseFuture.complete(null);
                            }
                        });
                    }
                } else {
                    this.getParent().releaseChild(this);
                    this.releaseFuture.complete(null);
                }
            });
        }
        return this.releaseFuture;
    }

    @Override
    public int getPhysicalSlotNumber() {
        return this.getRootSlotNumber();
    }

    @Override
    public AllocationID getAllocationId() {
        return this.getSlotContext().getAllocationId();
    }

    @Override
    public SlotRequestId getSlotRequestId() {
        return NO_SLOT_REQUEST_ID;
    }

    @Override
    @Nullable
    public SlotSharingGroupId getSlotSharingGroupId() {
        return NO_SLOT_SHARING_GROUP_ID;
    }

    @Override
    public String toString() {
        return "SimpleSlot " + super.toString();
    }
}

