/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.Serializable;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.executiongraph.ArchivedExecution;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.util.EvictingBoundedList;

public class ArchivedExecutionVertex
implements AccessExecutionVertex,
Serializable {
    private static final long serialVersionUID = -6708241535015028576L;
    private final int subTaskIndex;
    private final EvictingBoundedList<ArchivedExecution> priorExecutions;
    private final String taskNameWithSubtask;
    private final ArchivedExecution currentExecution;

    public ArchivedExecutionVertex(ExecutionVertex vertex) {
        this.subTaskIndex = vertex.getParallelSubtaskIndex();
        this.priorExecutions = vertex.getCopyOfPriorExecutionsList();
        this.taskNameWithSubtask = vertex.getTaskNameWithSubtaskIndex();
        this.currentExecution = vertex.getCurrentExecutionAttempt().archive();
    }

    public ArchivedExecutionVertex(int subTaskIndex, String taskNameWithSubtask, ArchivedExecution currentExecution, EvictingBoundedList<ArchivedExecution> priorExecutions) {
        this.subTaskIndex = subTaskIndex;
        this.taskNameWithSubtask = taskNameWithSubtask;
        this.currentExecution = currentExecution;
        this.priorExecutions = priorExecutions;
    }

    @Override
    public String getTaskNameWithSubtaskIndex() {
        return this.taskNameWithSubtask;
    }

    @Override
    public int getParallelSubtaskIndex() {
        return this.subTaskIndex;
    }

    @Override
    public ArchivedExecution getCurrentExecutionAttempt() {
        return this.currentExecution;
    }

    @Override
    public ExecutionState getExecutionState() {
        return this.currentExecution.getState();
    }

    @Override
    public long getStateTimestamp(ExecutionState state) {
        return this.currentExecution.getStateTimestamp(state);
    }

    @Override
    public String getFailureCauseAsString() {
        return this.currentExecution.getFailureCauseAsString();
    }

    @Override
    public TaskManagerLocation getCurrentAssignedResourceLocation() {
        return this.currentExecution.getAssignedResourceLocation();
    }

    @Override
    public ArchivedExecution getPriorExecutionAttempt(int attemptNumber) {
        if (attemptNumber >= 0 && attemptNumber < this.priorExecutions.size()) {
            return this.priorExecutions.get(attemptNumber);
        }
        throw new IllegalArgumentException("attempt does not exist");
    }
}

