/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStats;
import org.apache.flink.runtime.checkpoint.MinMaxAvgStats;
import org.apache.flink.util.Preconditions;

public class CompletedCheckpointStatsSummary
implements Serializable {
    private static final long serialVersionUID = 5784360461635814038L;
    private final MinMaxAvgStats stateSize;
    private final MinMaxAvgStats duration;
    private final MinMaxAvgStats alignmentBuffered;

    CompletedCheckpointStatsSummary() {
        this(new MinMaxAvgStats(), new MinMaxAvgStats(), new MinMaxAvgStats());
    }

    private CompletedCheckpointStatsSummary(MinMaxAvgStats stateSize, MinMaxAvgStats duration, MinMaxAvgStats alignmentBuffered) {
        this.stateSize = (MinMaxAvgStats)Preconditions.checkNotNull((Object)stateSize);
        this.duration = (MinMaxAvgStats)Preconditions.checkNotNull((Object)duration);
        this.alignmentBuffered = (MinMaxAvgStats)Preconditions.checkNotNull((Object)alignmentBuffered);
    }

    void updateSummary(CompletedCheckpointStats completed) {
        this.stateSize.add(completed.getStateSize());
        this.duration.add(completed.getEndToEndDuration());
        this.alignmentBuffered.add(completed.getAlignmentBuffered());
    }

    CompletedCheckpointStatsSummary createSnapshot() {
        return new CompletedCheckpointStatsSummary(this.stateSize.createSnapshot(), this.duration.createSnapshot(), this.alignmentBuffered.createSnapshot());
    }

    public MinMaxAvgStats getStateSizeStats() {
        return this.stateSize;
    }

    public MinMaxAvgStats getEndToEndDurationStats() {
        return this.duration;
    }

    public MinMaxAvgStats getAlignmentBufferedStats() {
        return this.alignmentBuffered;
    }
}

