/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.core.fs.FileSystemSafetyNet;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.SafetyNetCloseableRegistry;
import org.apache.flink.runtime.accumulators.AccumulatorRegistry;
import org.apache.flink.runtime.blob.BlobCacheService;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.broadcast.BroadcastVariableManager;
import org.apache.flink.runtime.checkpoint.CheckpointMetaData;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.decline.CheckpointDeclineTaskNotReadyException;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.deployment.InputGateDeploymentDescriptor;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.execution.CancelTaskException;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.JobInformation;
import org.apache.flink.runtime.executiongraph.TaskInformation;
import org.apache.flink.runtime.filecache.FileCache;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.NetworkEnvironment;
import org.apache.flink.runtime.io.network.netty.PartitionProducerStateChecker;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionConsumableNotifier;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionMetrics;
import org.apache.flink.runtime.io.network.partition.consumer.InputGateMetrics;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProvider;
import org.apache.flink.runtime.jobgraph.tasks.StoppableTask;
import org.apache.flink.runtime.jobmanager.PartitionProducerDisposedException;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.state.CheckpointListener;
import org.apache.flink.runtime.state.TaskStateManager;
import org.apache.flink.runtime.taskmanager.CheckpointResponder;
import org.apache.flink.runtime.taskmanager.DispatcherThreadFactory;
import org.apache.flink.runtime.taskmanager.RuntimeEnvironment;
import org.apache.flink.runtime.taskmanager.TaskActions;
import org.apache.flink.runtime.taskmanager.TaskExecutionState;
import org.apache.flink.runtime.taskmanager.TaskExecutionStateListener;
import org.apache.flink.runtime.taskmanager.TaskManagerActions;
import org.apache.flink.runtime.taskmanager.TaskManagerRuntimeInfo;
import org.apache.flink.runtime.util.FatalExitExceptionHandler;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.WrappingRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Task
implements Runnable,
TaskActions,
CheckpointListener {
    private static final Logger LOG = LoggerFactory.getLogger(Task.class);
    private static final ThreadGroup TASK_THREADS_GROUP = new ThreadGroup("Flink Task Threads");
    private static final AtomicReferenceFieldUpdater<Task, ExecutionState> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Task.class, ExecutionState.class, "executionState");
    private final JobID jobId;
    private final JobVertexID vertexId;
    private final ExecutionAttemptID executionId;
    private final AllocationID allocationId;
    private final TaskInfo taskInfo;
    private final String taskNameWithSubtask;
    private final Configuration jobConfiguration;
    private final Configuration taskConfiguration;
    private final Collection<PermanentBlobKey> requiredJarFiles;
    private final Collection<URL> requiredClasspaths;
    private final String nameOfInvokableClass;
    private final TaskManagerRuntimeInfo taskManagerConfig;
    private final MemoryManager memoryManager;
    private final IOManager ioManager;
    private final BroadcastVariableManager broadcastVariableManager;
    private final TaskStateManager taskStateManager;
    private final SerializedValue<ExecutionConfig> serializedExecutionConfig;
    private final ResultPartition[] producedPartitions;
    private final SingleInputGate[] inputGates;
    private final Map<IntermediateDataSetID, SingleInputGate> inputGatesById;
    private final TaskManagerActions taskManagerActions;
    private final InputSplitProvider inputSplitProvider;
    private final CheckpointResponder checkpointResponder;
    private final List<TaskExecutionStateListener> taskExecutionStateListeners;
    private final BlobCacheService blobService;
    private final LibraryCacheManager libraryCache;
    private final FileCache fileCache;
    private final NetworkEnvironment network;
    private final AccumulatorRegistry accumulatorRegistry;
    private final Thread executingThread;
    private final TaskMetricGroup metrics;
    private final PartitionProducerStateChecker partitionProducerStateChecker;
    private final Executor executor;
    private final AtomicBoolean invokableHasBeenCanceled;
    @Nullable
    private volatile AbstractInvokable invokable;
    private volatile ExecutionState executionState = ExecutionState.CREATED;
    private volatile Throwable failureCause;
    private volatile ExecutorService asyncCallDispatcher;
    private long taskCancellationInterval;
    private long taskCancellationTimeout;
    private ClassLoader userCodeClassLoader;

    public Task(JobInformation jobInformation, TaskInformation taskInformation, ExecutionAttemptID executionAttemptID, AllocationID slotAllocationId, int subtaskIndex, int attemptNumber, Collection<ResultPartitionDeploymentDescriptor> resultPartitionDeploymentDescriptors, Collection<InputGateDeploymentDescriptor> inputGateDeploymentDescriptors, int targetSlotNumber, MemoryManager memManager, IOManager ioManager, NetworkEnvironment networkEnvironment, BroadcastVariableManager bcVarManager, TaskStateManager taskStateManager, TaskManagerActions taskManagerActions, InputSplitProvider inputSplitProvider, CheckpointResponder checkpointResponder, BlobCacheService blobService, LibraryCacheManager libraryCache, FileCache fileCache, TaskManagerRuntimeInfo taskManagerConfig, @Nonnull TaskMetricGroup metricGroup, ResultPartitionConsumableNotifier resultPartitionConsumableNotifier, PartitionProducerStateChecker partitionProducerStateChecker, Executor executor) {
        Preconditions.checkNotNull((Object)jobInformation);
        Preconditions.checkNotNull((Object)taskInformation);
        Preconditions.checkArgument((0 <= subtaskIndex ? 1 : 0) != 0, (Object)"The subtask index must be positive.");
        Preconditions.checkArgument((0 <= attemptNumber ? 1 : 0) != 0, (Object)"The attempt number must be positive.");
        Preconditions.checkArgument((0 <= targetSlotNumber ? 1 : 0) != 0, (Object)"The target slot number must be positive.");
        this.taskInfo = new TaskInfo(taskInformation.getTaskName(), taskInformation.getMaxNumberOfSubtaks(), subtaskIndex, taskInformation.getNumberOfSubtasks(), attemptNumber, String.valueOf((Object)slotAllocationId));
        this.jobId = jobInformation.getJobId();
        this.vertexId = taskInformation.getJobVertexId();
        this.executionId = (ExecutionAttemptID)((Object)Preconditions.checkNotNull((Object)((Object)executionAttemptID)));
        this.allocationId = (AllocationID)((Object)Preconditions.checkNotNull((Object)((Object)slotAllocationId)));
        this.taskNameWithSubtask = this.taskInfo.getTaskNameWithSubtasks();
        this.jobConfiguration = jobInformation.getJobConfiguration();
        this.taskConfiguration = taskInformation.getTaskConfiguration();
        this.requiredJarFiles = jobInformation.getRequiredJarFileBlobKeys();
        this.requiredClasspaths = jobInformation.getRequiredClasspathURLs();
        this.nameOfInvokableClass = taskInformation.getInvokableClassName();
        this.serializedExecutionConfig = jobInformation.getSerializedExecutionConfig();
        Configuration tmConfig = taskManagerConfig.getConfiguration();
        this.taskCancellationInterval = tmConfig.getLong(TaskManagerOptions.TASK_CANCELLATION_INTERVAL);
        this.taskCancellationTimeout = tmConfig.getLong(TaskManagerOptions.TASK_CANCELLATION_TIMEOUT);
        this.memoryManager = (MemoryManager)Preconditions.checkNotNull((Object)memManager);
        this.ioManager = (IOManager)Preconditions.checkNotNull((Object)ioManager);
        this.broadcastVariableManager = (BroadcastVariableManager)Preconditions.checkNotNull((Object)bcVarManager);
        this.taskStateManager = (TaskStateManager)Preconditions.checkNotNull((Object)taskStateManager);
        this.accumulatorRegistry = new AccumulatorRegistry(this.jobId, this.executionId);
        this.inputSplitProvider = (InputSplitProvider)Preconditions.checkNotNull((Object)inputSplitProvider);
        this.checkpointResponder = (CheckpointResponder)Preconditions.checkNotNull((Object)checkpointResponder);
        this.taskManagerActions = (TaskManagerActions)Preconditions.checkNotNull((Object)taskManagerActions);
        this.blobService = (BlobCacheService)Preconditions.checkNotNull((Object)blobService);
        this.libraryCache = (LibraryCacheManager)Preconditions.checkNotNull((Object)libraryCache);
        this.fileCache = (FileCache)Preconditions.checkNotNull((Object)fileCache);
        this.network = (NetworkEnvironment)Preconditions.checkNotNull((Object)networkEnvironment);
        this.taskManagerConfig = (TaskManagerRuntimeInfo)Preconditions.checkNotNull((Object)taskManagerConfig);
        this.taskExecutionStateListeners = new CopyOnWriteArrayList<TaskExecutionStateListener>();
        this.metrics = metricGroup;
        this.partitionProducerStateChecker = (PartitionProducerStateChecker)Preconditions.checkNotNull((Object)partitionProducerStateChecker);
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
        String taskNameWithSubtaskAndId = this.taskNameWithSubtask + " (" + (Object)((Object)this.executionId) + ')';
        this.producedPartitions = new ResultPartition[resultPartitionDeploymentDescriptors.size()];
        int counter = 0;
        for (ResultPartitionDeploymentDescriptor desc : resultPartitionDeploymentDescriptors) {
            ResultPartitionID partitionId = new ResultPartitionID(desc.getPartitionId(), this.executionId);
            this.producedPartitions[counter] = new ResultPartition(taskNameWithSubtaskAndId, this, this.jobId, partitionId, desc.getPartitionType(), desc.getNumberOfSubpartitions(), desc.getMaxParallelism(), networkEnvironment.getResultPartitionManager(), resultPartitionConsumableNotifier, ioManager, desc.sendScheduleOrUpdateConsumersMessage());
            ++counter;
        }
        this.inputGates = new SingleInputGate[inputGateDeploymentDescriptors.size()];
        this.inputGatesById = new HashMap<IntermediateDataSetID, SingleInputGate>();
        counter = 0;
        for (InputGateDeploymentDescriptor inputGateDeploymentDescriptor : inputGateDeploymentDescriptors) {
            SingleInputGate gate;
            this.inputGates[counter] = gate = SingleInputGate.create(taskNameWithSubtaskAndId, this.jobId, this.executionId, inputGateDeploymentDescriptor, networkEnvironment, this, metricGroup.getIOMetricGroup());
            this.inputGatesById.put(gate.getConsumedResultId(), gate);
            ++counter;
        }
        this.invokableHasBeenCanceled = new AtomicBoolean(false);
        this.executingThread = new Thread(TASK_THREADS_GROUP, this, this.taskNameWithSubtask);
    }

    public JobID getJobID() {
        return this.jobId;
    }

    public JobVertexID getJobVertexId() {
        return this.vertexId;
    }

    public ExecutionAttemptID getExecutionId() {
        return this.executionId;
    }

    public AllocationID getAllocationId() {
        return this.allocationId;
    }

    public TaskInfo getTaskInfo() {
        return this.taskInfo;
    }

    public Configuration getJobConfiguration() {
        return this.jobConfiguration;
    }

    public Configuration getTaskConfiguration() {
        return this.taskConfiguration;
    }

    public SingleInputGate[] getAllInputGates() {
        return this.inputGates;
    }

    public ResultPartition[] getProducedPartitions() {
        return this.producedPartitions;
    }

    public SingleInputGate getInputGateById(IntermediateDataSetID id) {
        return this.inputGatesById.get((Object)id);
    }

    public AccumulatorRegistry getAccumulatorRegistry() {
        return this.accumulatorRegistry;
    }

    public TaskMetricGroup getMetricGroup() {
        return this.metrics;
    }

    public Thread getExecutingThread() {
        return this.executingThread;
    }

    @VisibleForTesting
    long getTaskCancellationInterval() {
        return this.taskCancellationInterval;
    }

    @VisibleForTesting
    long getTaskCancellationTimeout() {
        return this.taskCancellationTimeout;
    }

    @Nullable
    @VisibleForTesting
    AbstractInvokable getInvokable() {
        return this.invokable;
    }

    public ExecutionState getExecutionState() {
        return this.executionState;
    }

    public boolean isCanceledOrFailed() {
        return this.executionState == ExecutionState.CANCELING || this.executionState == ExecutionState.CANCELED || this.executionState == ExecutionState.FAILED;
    }

    public Throwable getFailureCause() {
        return this.failureCause;
    }

    public void startTaskThread() {
        this.executingThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        while (true) {
            block51: {
                if ((current = this.executionState) != ExecutionState.CREATED) break block51;
                if (!this.transitionState(ExecutionState.CREATED, ExecutionState.DEPLOYING)) continue;
                distributedCacheEntries = new HashMap<String, Future<Path>>();
                invokable = null;
                ** try [egrp 0[TRYBLOCK] [3, 9 : 153->885)] { 
lbl7:
                // 1 sources

                ** GOTO lbl-1000
            }
            if (current == ExecutionState.FAILED) {
                this.notifyFinalState();
                if (this.metrics == null) return;
                this.metrics.close();
                return;
            }
            if (current != ExecutionState.CANCELING) {
                if (this.metrics == null) throw new IllegalStateException("Invalid state for beginning of operation of task " + this + '.');
                this.metrics.close();
                throw new IllegalStateException("Invalid state for beginning of operation of task " + this + '.');
            }
            if (this.transitionState(ExecutionState.CANCELING, ExecutionState.CANCELED)) break;
        }
        this.notifyFinalState();
        if (this.metrics == null) return;
        this.metrics.close();
        return;
lbl-1000:
        // 1 sources

        {
            Task.LOG.info("Creating FileSystem stream leak safety net for task {}", (Object)this);
            FileSystemSafetyNet.initializeSafetyNetForThread();
            this.blobService.getPermanentBlobService().registerJob(this.jobId);
            Task.LOG.info("Loading JAR files for task {}.", (Object)this);
            this.userCodeClassLoader = this.createUserCodeClassloader();
            executionConfig = (ExecutionConfig)this.serializedExecutionConfig.deserializeValue(this.userCodeClassLoader);
            if (executionConfig.getTaskCancellationInterval() >= 0L) {
                this.taskCancellationInterval = executionConfig.getTaskCancellationInterval();
            }
            if (executionConfig.getTaskCancellationTimeout() >= 0L) {
                this.taskCancellationTimeout = executionConfig.getTaskCancellationTimeout();
            }
            if (this.isCanceledOrFailed()) {
                throw new CancelTaskException();
            }
            Task.LOG.info("Registering task at network: {}.", (Object)this);
            this.network.registerTask(this);
            this.metrics.getIOMetricGroup().initializeBufferMetrics(this);
            if (this.taskManagerConfig.getConfiguration().getBoolean(TaskManagerOptions.NETWORK_DETAILED_METRICS)) {
                networkGroup = this.metrics.getIOMetricGroup().addGroup("Network");
                outputGroup = networkGroup.addGroup("Output");
                inputGroup = networkGroup.addGroup("Input");
                for (i = 0; i < this.producedPartitions.length; ++i) {
                    ResultPartitionMetrics.registerQueueLengthMetrics(outputGroup.addGroup(i), this.producedPartitions[i]);
                }
                for (i = 0; i < this.inputGates.length; ++i) {
                    InputGateMetrics.registerQueueLengthMetrics(inputGroup.addGroup(i), this.inputGates[i]);
                }
            }
            try {
                for (Map.Entry entry : DistributedCache.readFileInfoFromConfig((Configuration)this.jobConfiguration)) {
                    Task.LOG.info("Obtaining local cache file for '{}'.", entry.getKey());
                    cp = this.fileCache.createTmpFile((String)entry.getKey(), (DistributedCache.DistributedCacheEntry)entry.getValue(), this.jobId, this.executionId);
                    distributedCacheEntries.put((String)entry.getKey(), cp);
                }
            }
            catch (Exception e) {
                throw new Exception(String.format("Exception while adding files to distributed cache of task %s (%s).", new Object[]{this.taskNameWithSubtask, this.executionId}), e);
            }
            if (this.isCanceledOrFailed()) {
                throw new CancelTaskException();
            }
            kvStateRegistry = this.network.createKvStateTaskRegistry(this.jobId, this.getJobVertexId());
            env = new RuntimeEnvironment(this.jobId, this.vertexId, this.executionId, executionConfig, this.taskInfo, this.jobConfiguration, this.taskConfiguration, this.userCodeClassLoader, this.memoryManager, this.ioManager, this.broadcastVariableManager, this.taskStateManager, this.accumulatorRegistry, kvStateRegistry, this.inputSplitProvider, distributedCacheEntries, this.producedPartitions, this.inputGates, this.network.getTaskEventDispatcher(), this.checkpointResponder, this.taskManagerConfig, this.metrics, this);
            this.invokable = invokable = Task.loadAndInstantiateInvokable(this.userCodeClassLoader, this.nameOfInvokableClass, env);
            if (!this.transitionState(ExecutionState.DEPLOYING, ExecutionState.RUNNING)) {
                throw new CancelTaskException();
            }
            this.notifyObservers(ExecutionState.RUNNING, null);
            this.taskManagerActions.updateTaskExecutionState(new TaskExecutionState(this.jobId, this.executionId, ExecutionState.RUNNING));
            this.executingThread.setContextClassLoader(this.userCodeClassLoader);
            invokable.invoke();
            if (this.isCanceledOrFailed()) {
                throw new CancelTaskException();
            }
            for (ResultPartition partition : this.producedPartitions) {
                if (partition == null) continue;
                partition.finish();
            }
            if (this.transitionState(ExecutionState.RUNNING, ExecutionState.FINISHED) == false) throw new CancelTaskException();
            this.notifyObservers(ExecutionState.FINISHED, null);
        }
        try {
            Task.LOG.info("Freeing task resources for {} ({}).", (Object)this.taskNameWithSubtask, (Object)this.executionId);
            this.invokable = null;
            dispatcher = this.asyncCallDispatcher;
            if (dispatcher != null && !dispatcher.isShutdown()) {
                dispatcher.shutdownNow();
            }
            this.network.unregisterTask(this);
            if (invokable != null) {
                this.memoryManager.releaseAll(invokable);
            }
            this.libraryCache.unregisterTask(this.jobId, this.executionId);
            this.fileCache.releaseJob(this.jobId, this.executionId);
            this.blobService.getPermanentBlobService().releaseJob(this.jobId);
            Task.LOG.info("Ensuring all FileSystem streams are closed for task {}", (Object)this);
            FileSystemSafetyNet.closeSafetyNetAndGuardedResourcesForThread();
            this.notifyFinalState();
        }
        catch (Throwable t) {
            message = String.format("FATAL - exception in resource cleanup of task %s (%s).", new Object[]{this.taskNameWithSubtask, this.executionId});
            Task.LOG.error(message, t);
            this.notifyFatalError(message, t);
        }
        try {
            this.metrics.close();
            return;
        }
        catch (Throwable t) {
            Task.LOG.error("Error during metrics de-registration of task {} ({}).", new Object[]{this.taskNameWithSubtask, this.executionId, t});
            return;
        }
lbl105:
        // 1 sources

        catch (Throwable t) {
            block50: {
                block49: {
                    try {
                        if (t instanceof WrappingRuntimeException) {
                            t = ((WrappingRuntimeException)t).unwrap();
                        }
                        try {
                            if (!ExceptionUtils.isJvmFatalError((Throwable)t) && (!(t instanceof OutOfMemoryError) || !this.taskManagerConfig.shouldExitJvmOnOutOfMemoryError())) break block49;
                            try {
                                Task.LOG.error("Encountered fatal error {} - terminating the JVM", (Object)t.getClass().getName(), (Object)t);
                            }
                            finally {
                                Runtime.getRuntime().halt(-1);
                            }
                        }
                        catch (Throwable tt) {
                            message = String.format("FATAL - exception in exception handler of task %s (%s).", new Object[]{this.taskNameWithSubtask, this.executionId});
                            Task.LOG.error(message, tt);
                            this.notifyFatalError(message, tt);
                            break block50;
                        }
                    }
lbl122:
                    // 2 sources

                    catch (Throwable var11_22) {
                        try {
                            Task.LOG.info("Freeing task resources for {} ({}).", (Object)this.taskNameWithSubtask, (Object)this.executionId);
                            this.invokable = null;
                            dispatcher = this.asyncCallDispatcher;
                            if (dispatcher != null && !dispatcher.isShutdown()) {
                                dispatcher.shutdownNow();
                            }
                            this.network.unregisterTask(this);
                            if (invokable != null) {
                                this.memoryManager.releaseAll(invokable);
                            }
                            this.libraryCache.unregisterTask(this.jobId, this.executionId);
                            this.fileCache.releaseJob(this.jobId, this.executionId);
                            this.blobService.getPermanentBlobService().releaseJob(this.jobId);
                            Task.LOG.info("Ensuring all FileSystem streams are closed for task {}", (Object)this);
                            FileSystemSafetyNet.closeSafetyNetAndGuardedResourcesForThread();
                            this.notifyFinalState();
                        }
                        catch (Throwable t) {
                            message = String.format("FATAL - exception in resource cleanup of task %s (%s).", new Object[]{this.taskNameWithSubtask, this.executionId});
                            Task.LOG.error(message, t);
                            this.notifyFatalError(message, t);
                        }
                        try {
                            this.metrics.close();
                            throw var11_22;
                        }
                        catch (Throwable t) {
                            Task.LOG.error("Error during metrics de-registration of task {} ({}).", new Object[]{this.taskNameWithSubtask, this.executionId, t});
                        }
                        throw var11_22;
                    }
                }
                while (true) {
                    if ((current = this.executionState) == ExecutionState.RUNNING || current == ExecutionState.DEPLOYING) {
                        if (t instanceof CancelTaskException) {
                            if (!this.transitionState(current, ExecutionState.CANCELED)) continue;
                            this.cancelInvokable(invokable);
                            this.notifyObservers(ExecutionState.CANCELED, null);
                            break block50;
                        } else {
                            if (!this.transitionState(current, ExecutionState.FAILED, t)) continue;
                            errorMessage = String.format("Execution of %s (%s) failed.", new Object[]{this.taskNameWithSubtask, this.executionId});
                            this.failureCause = t;
                            this.cancelInvokable(invokable);
                            this.notifyObservers(ExecutionState.FAILED, new Exception(errorMessage, t));
                        }
                        break block50;
                    }
                    if (current == ExecutionState.CANCELING) {
                        if (!this.transitionState(current, ExecutionState.CANCELED)) continue;
                        this.notifyObservers(ExecutionState.CANCELED, null);
                        break block50;
                    }
                    if (current == ExecutionState.FAILED) break block50;
                    if (this.transitionState(current, ExecutionState.FAILED, t)) break;
                }
                Task.LOG.error("Unexpected state in task {} ({}) during an exception: {}.", new Object[]{this.taskNameWithSubtask, this.executionId, current});
            }
            try {
                Task.LOG.info("Freeing task resources for {} ({}).", (Object)this.taskNameWithSubtask, (Object)this.executionId);
                this.invokable = null;
                dispatcher = this.asyncCallDispatcher;
                if (dispatcher != null && !dispatcher.isShutdown()) {
                    dispatcher.shutdownNow();
                }
                this.network.unregisterTask(this);
                if (invokable != null) {
                    this.memoryManager.releaseAll(invokable);
                }
                this.libraryCache.unregisterTask(this.jobId, this.executionId);
                this.fileCache.releaseJob(this.jobId, this.executionId);
                this.blobService.getPermanentBlobService().releaseJob(this.jobId);
                Task.LOG.info("Ensuring all FileSystem streams are closed for task {}", (Object)this);
                FileSystemSafetyNet.closeSafetyNetAndGuardedResourcesForThread();
                this.notifyFinalState();
            }
            catch (Throwable t) {
                message = String.format("FATAL - exception in resource cleanup of task %s (%s).", new Object[]{this.taskNameWithSubtask, this.executionId});
                Task.LOG.error(message, t);
                this.notifyFatalError(message, t);
            }
            try {
                this.metrics.close();
                return;
            }
            catch (Throwable t) {
                Task.LOG.error("Error during metrics de-registration of task {} ({}).", new Object[]{this.taskNameWithSubtask, this.executionId, t});
                return;
            }
        }
    }

    private ClassLoader createUserCodeClassloader() throws Exception {
        long startDownloadTime = System.currentTimeMillis();
        this.libraryCache.registerTask(this.jobId, this.executionId, this.requiredJarFiles, this.requiredClasspaths);
        LOG.debug("Getting user code class loader for task {} at library cache manager took {} milliseconds", (Object)this.executionId, (Object)(System.currentTimeMillis() - startDownloadTime));
        ClassLoader userCodeClassLoader = this.libraryCache.getClassLoader(this.jobId);
        if (userCodeClassLoader == null) {
            throw new Exception("No user code classloader available.");
        }
        return userCodeClassLoader;
    }

    private void notifyFinalState() {
        this.taskManagerActions.notifyFinalState(this.executionId);
    }

    private void notifyFatalError(String message, Throwable cause) {
        this.taskManagerActions.notifyFatalError(message, cause);
    }

    private boolean transitionState(ExecutionState currentState, ExecutionState newState) {
        return this.transitionState(currentState, newState, null);
    }

    private boolean transitionState(ExecutionState currentState, ExecutionState newState, Throwable cause) {
        if (STATE_UPDATER.compareAndSet(this, currentState, newState)) {
            if (cause == null) {
                LOG.info("{} ({}) switched from {} to {}.", new Object[]{this.taskNameWithSubtask, this.executionId, currentState, newState});
            } else {
                LOG.info("{} ({}) switched from {} to {}.", new Object[]{this.taskNameWithSubtask, this.executionId, currentState, newState, cause});
            }
            return true;
        }
        return false;
    }

    public void stopExecution() {
        AbstractInvokable invokable = this.invokable;
        if (invokable != null) {
            if (!(invokable instanceof StoppableTask)) {
                throw new UnsupportedOperationException(String.format("Stopping not supported by task %s (%s).", new Object[]{this.taskNameWithSubtask, this.executionId}));
            }
        } else {
            throw new IllegalStateException(String.format("Cannot stop task %s (%s) because it is not running.", new Object[]{this.taskNameWithSubtask, this.executionId}));
        }
        LOG.info("Attempting to stop task {} ({}).", (Object)this.taskNameWithSubtask, (Object)this.executionId);
        StoppableTask stoppable = (StoppableTask)((Object)invokable);
        Runnable runnable = () -> {
            try {
                stoppable.stop();
            }
            catch (Throwable t) {
                LOG.error("Stopping task {} ({}) failed.", new Object[]{this.taskNameWithSubtask, this.executionId, t});
                this.taskManagerActions.failTask(this.executionId, t);
            }
        };
        this.executeAsyncCallRunnable(runnable, String.format("Stopping source task %s (%s).", new Object[]{this.taskNameWithSubtask, this.executionId}));
    }

    public void cancelExecution() {
        LOG.info("Attempting to cancel task {} ({}).", (Object)this.taskNameWithSubtask, (Object)this.executionId);
        this.cancelOrFailAndCancelInvokable(ExecutionState.CANCELING, null);
    }

    @Override
    public void failExternally(Throwable cause) {
        LOG.info("Attempting to fail task externally {} ({}).", (Object)this.taskNameWithSubtask, (Object)this.executionId);
        this.cancelOrFailAndCancelInvokable(ExecutionState.FAILED, cause);
    }

    private void cancelOrFailAndCancelInvokable(ExecutionState targetState, Throwable cause) {
        ExecutionState current;
        block6: {
            while (true) {
                if ((current = this.executionState).isTerminal() || current == ExecutionState.CANCELING) {
                    LOG.info("Task {} is already in state {}", (Object)this.taskNameWithSubtask, (Object)current);
                    return;
                }
                if (current == ExecutionState.DEPLOYING || current == ExecutionState.CREATED) {
                    if (!this.transitionState(current, targetState, cause)) continue;
                    this.failureCause = cause;
                    this.notifyObservers(targetState, new Exception(String.format("Cancel or fail execution of %s (%s).", new Object[]{this.taskNameWithSubtask, this.executionId}), cause));
                    return;
                }
                if (current != ExecutionState.RUNNING) break block6;
                if (this.transitionState(ExecutionState.RUNNING, targetState, cause)) break;
            }
            AbstractInvokable invokable = this.invokable;
            if (invokable != null && this.invokableHasBeenCanceled.compareAndSet(false, true)) {
                this.failureCause = cause;
                this.notifyObservers(targetState, new Exception(String.format("Cancel or fail execution of %s (%s).", new Object[]{this.taskNameWithSubtask, this.executionId}), cause));
                LOG.info("Triggering cancellation of task code {} ({}).", (Object)this.taskNameWithSubtask, (Object)this.executionId);
                TaskCanceler canceler = new TaskCanceler(LOG, invokable, this.executingThread, this.taskNameWithSubtask, this.producedPartitions, this.inputGates);
                Thread cancelThread = new Thread(this.executingThread.getThreadGroup(), canceler, String.format("Canceler for %s (%s).", new Object[]{this.taskNameWithSubtask, this.executionId}));
                cancelThread.setDaemon(true);
                cancelThread.setUncaughtExceptionHandler(FatalExitExceptionHandler.INSTANCE);
                cancelThread.start();
                if (invokable.shouldInterruptOnCancel()) {
                    TaskInterrupter interrupter = new TaskInterrupter(LOG, invokable, this.executingThread, this.taskNameWithSubtask, this.taskCancellationInterval);
                    Thread interruptingThread = new Thread(this.executingThread.getThreadGroup(), interrupter, String.format("Canceler/Interrupts for %s (%s).", new Object[]{this.taskNameWithSubtask, this.executionId}));
                    interruptingThread.setDaemon(true);
                    interruptingThread.setUncaughtExceptionHandler(FatalExitExceptionHandler.INSTANCE);
                    interruptingThread.start();
                }
                if (this.taskCancellationTimeout > 0L) {
                    TaskCancelerWatchDog cancelWatchdog = new TaskCancelerWatchDog(this.executingThread, this.taskManagerActions, this.taskCancellationTimeout, LOG);
                    Thread watchDogThread = new Thread(this.executingThread.getThreadGroup(), cancelWatchdog, String.format("Cancellation Watchdog for %s (%s).", new Object[]{this.taskNameWithSubtask, this.executionId}));
                    watchDogThread.setDaemon(true);
                    watchDogThread.setUncaughtExceptionHandler(FatalExitExceptionHandler.INSTANCE);
                    watchDogThread.start();
                }
            }
            return;
        }
        throw new IllegalStateException(String.format("Unexpected state: %s of task %s (%s).", new Object[]{current, this.taskNameWithSubtask, this.executionId}));
    }

    public void registerExecutionListener(TaskExecutionStateListener listener) {
        this.taskExecutionStateListeners.add(listener);
    }

    private void notifyObservers(ExecutionState newState, Throwable error) {
        TaskExecutionState stateUpdate = new TaskExecutionState(this.jobId, this.executionId, newState, error);
        for (TaskExecutionStateListener listener : this.taskExecutionStateListeners) {
            listener.notifyTaskExecutionStateChanged(stateUpdate);
        }
    }

    @Override
    public void triggerPartitionProducerStateCheck(JobID jobId, IntermediateDataSetID intermediateDataSetId, ResultPartitionID resultPartitionId) {
        CompletableFuture<ExecutionState> futurePartitionState = this.partitionProducerStateChecker.requestPartitionProducerState(jobId, intermediateDataSetId, resultPartitionId);
        futurePartitionState.whenCompleteAsync((executionState, throwable) -> {
            try {
                if (executionState != null) {
                    this.onPartitionStateUpdate(intermediateDataSetId, resultPartitionId, (ExecutionState)((Object)executionState));
                } else if (throwable instanceof TimeoutException) {
                    this.onPartitionStateUpdate(intermediateDataSetId, resultPartitionId, ExecutionState.RUNNING);
                } else if (throwable instanceof PartitionProducerDisposedException) {
                    String msg = String.format("Producer %s of partition %s disposed. Cancelling execution.", new Object[]{resultPartitionId.getProducerId(), resultPartitionId.getPartitionId()});
                    LOG.info(msg, throwable);
                    this.cancelExecution();
                } else {
                    this.failExternally((Throwable)throwable);
                }
            }
            catch (IOException | InterruptedException e) {
                this.failExternally(e);
            }
        }, this.executor);
    }

    public void triggerCheckpointBarrier(final long checkpointID, long checkpointTimestamp, final CheckpointOptions checkpointOptions) {
        final AbstractInvokable invokable = this.invokable;
        final CheckpointMetaData checkpointMetaData = new CheckpointMetaData(checkpointID, checkpointTimestamp);
        if (this.executionState == ExecutionState.RUNNING && invokable != null) {
            final String taskName = this.taskNameWithSubtask;
            final SafetyNetCloseableRegistry safetyNetCloseableRegistry = FileSystemSafetyNet.getSafetyNetCloseableRegistryForThread();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    LOG.debug("Creating FileSystem stream leak safety net for {}", (Object)Thread.currentThread().getName());
                    FileSystemSafetyNet.setSafetyNetCloseableRegistryForThread((SafetyNetCloseableRegistry)safetyNetCloseableRegistry);
                    try {
                        boolean success = invokable.triggerCheckpoint(checkpointMetaData, checkpointOptions);
                        if (!success) {
                            Task.this.checkpointResponder.declineCheckpoint(Task.this.getJobID(), Task.this.getExecutionId(), checkpointID, new CheckpointDeclineTaskNotReadyException(taskName));
                        }
                    }
                    catch (Throwable t) {
                        if (Task.this.getExecutionState() == ExecutionState.RUNNING) {
                            Task.this.failExternally(new Exception("Error while triggering checkpoint " + checkpointID + " for " + Task.this.taskNameWithSubtask, t));
                        } else {
                            LOG.debug("Encountered error while triggering checkpoint {} for {} ({}) while being not in state running.", new Object[]{checkpointID, Task.this.taskNameWithSubtask, Task.this.executionId, t});
                        }
                    }
                    finally {
                        FileSystemSafetyNet.setSafetyNetCloseableRegistryForThread(null);
                    }
                }
            };
            this.executeAsyncCallRunnable(runnable, String.format("Checkpoint Trigger for %s (%s).", new Object[]{this.taskNameWithSubtask, this.executionId}));
        } else {
            LOG.debug("Declining checkpoint request for non-running task {} ({}).", (Object)this.taskNameWithSubtask, (Object)this.executionId);
            this.checkpointResponder.declineCheckpoint(this.jobId, this.executionId, checkpointID, new CheckpointDeclineTaskNotReadyException(this.taskNameWithSubtask));
        }
    }

    @Override
    public void notifyCheckpointComplete(final long checkpointID) {
        final AbstractInvokable invokable = this.invokable;
        if (this.executionState == ExecutionState.RUNNING && invokable != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            invokable.notifyCheckpointComplete(checkpointID);
                            Task.this.taskStateManager.notifyCheckpointComplete(checkpointID);
                        }
                        catch (Throwable t) {
                            if (Task.this.getExecutionState() != ExecutionState.RUNNING) break block2;
                            Task.this.failExternally(new RuntimeException("Error while confirming checkpoint", t));
                        }
                    }
                }
            };
            this.executeAsyncCallRunnable(runnable, "Checkpoint Confirmation for " + this.taskNameWithSubtask);
        } else {
            LOG.debug("Ignoring checkpoint commit notification for non-running task {}.", (Object)this.taskNameWithSubtask);
        }
    }

    @VisibleForTesting
    void onPartitionStateUpdate(IntermediateDataSetID intermediateDataSetId, ResultPartitionID resultPartitionId, ExecutionState producerState) throws IOException, InterruptedException {
        if (this.executionState == ExecutionState.RUNNING) {
            SingleInputGate inputGate = this.inputGatesById.get((Object)intermediateDataSetId);
            if (inputGate != null) {
                if (producerState == ExecutionState.SCHEDULED || producerState == ExecutionState.DEPLOYING || producerState == ExecutionState.RUNNING || producerState == ExecutionState.FINISHED) {
                    inputGate.retriggerPartitionRequest(resultPartitionId.getPartitionId());
                } else if (producerState == ExecutionState.CANCELING || producerState == ExecutionState.CANCELED || producerState == ExecutionState.FAILED) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Cancelling task {} after the producer of partition {} with attempt ID {} has entered state {}.", new Object[]{this.taskNameWithSubtask, resultPartitionId.getPartitionId(), resultPartitionId.getProducerId(), producerState});
                    }
                    this.cancelExecution();
                } else {
                    String msg = String.format("Producer with attempt ID %s of partition %s in unexpected state %s.", new Object[]{resultPartitionId.getProducerId(), resultPartitionId.getPartitionId(), producerState});
                    this.failExternally(new IllegalStateException(msg));
                }
            } else {
                this.failExternally(new IllegalStateException("Received partition producer state for unknown input gate " + (Object)((Object)intermediateDataSetId) + "."));
            }
        } else {
            LOG.debug("Task {} ignored a partition producer state notification, because it's not running.", (Object)this.taskNameWithSubtask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAsyncCallRunnable(Runnable runnable, String callName) {
        Task task = this;
        synchronized (task) {
            block8: {
                if (this.executionState != ExecutionState.RUNNING) {
                    return;
                }
                ExecutorService executor = this.asyncCallDispatcher;
                if (executor == null) {
                    Preconditions.checkState((this.userCodeClassLoader != null ? 1 : 0) != 0, (Object)"userCodeClassLoader must not be null");
                    this.asyncCallDispatcher = executor = Executors.newSingleThreadExecutor(new DispatcherThreadFactory(TASK_THREADS_GROUP, "Async calls on " + this.taskNameWithSubtask, this.userCodeClassLoader));
                    if (this.executionState != ExecutionState.RUNNING) {
                        executor.shutdown();
                        this.asyncCallDispatcher = null;
                        return;
                    }
                }
                LOG.debug("Invoking async call {} on task {}", (Object)callName, (Object)this.taskNameWithSubtask);
                try {
                    executor.submit(runnable);
                }
                catch (RejectedExecutionException e) {
                    if (this.executionState != ExecutionState.RUNNING) break block8;
                    throw new RuntimeException("Async call was rejected, even though the task is running.", e);
                }
            }
        }
    }

    private void cancelInvokable(AbstractInvokable invokable) {
        if (invokable != null && this.invokableHasBeenCanceled.compareAndSet(false, true)) {
            try {
                invokable.cancel();
            }
            catch (Throwable t) {
                LOG.error("Error while canceling task {}.", (Object)this.taskNameWithSubtask, (Object)t);
            }
        }
    }

    public String toString() {
        return String.format("%s (%s) [%s]", new Object[]{this.taskNameWithSubtask, this.executionId, this.executionState});
    }

    private static AbstractInvokable loadAndInstantiateInvokable(ClassLoader classLoader, String className, Environment environment) throws Throwable {
        Constructor<AbstractInvokable> statelessCtor;
        Class<AbstractInvokable> invokableClass;
        try {
            invokableClass = Class.forName(className, true, classLoader).asSubclass(AbstractInvokable.class);
        }
        catch (Throwable t) {
            throw new Exception("Could not load the task's invokable class.", t);
        }
        try {
            statelessCtor = invokableClass.getConstructor(Environment.class);
        }
        catch (NoSuchMethodException ee) {
            throw new FlinkException("Task misses proper constructor", (Throwable)ee);
        }
        try {
            return statelessCtor.newInstance(environment);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        catch (Exception e) {
            throw new FlinkException("Could not instantiate the task's invokable class.", (Throwable)e);
        }
    }

    private static class TaskCancelerWatchDog
    implements Runnable {
        private final Logger log;
        private final Thread executerThread;
        private final TaskManagerActions taskManager;
        private final long timeoutMillis;

        TaskCancelerWatchDog(Thread executerThread, TaskManagerActions taskManager, long timeoutMillis, Logger log) {
            Preconditions.checkArgument((timeoutMillis > 0L ? 1 : 0) != 0);
            this.log = log;
            this.executerThread = executerThread;
            this.taskManager = taskManager;
            this.timeoutMillis = timeoutMillis;
        }

        @Override
        public void run() {
            try {
                long millisLeft;
                long hardKillDeadline = System.nanoTime() + this.timeoutMillis * 1000000L;
                while (this.executerThread.isAlive() && (millisLeft = (hardKillDeadline - System.nanoTime()) / 1000000L) > 0L) {
                    try {
                        this.executerThread.join(millisLeft);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.executerThread.isAlive()) {
                    String msg = "Task did not exit gracefully within " + this.timeoutMillis / 1000L + " + seconds.";
                    this.log.error(msg);
                    this.taskManager.notifyFatalError(msg, null);
                }
            }
            catch (Throwable t) {
                ExceptionUtils.rethrowIfFatalError((Throwable)t);
                this.log.error("Error in Task Cancellation Watch Dog", t);
            }
        }
    }

    private static final class TaskInterrupter
    implements Runnable {
        private final Logger log;
        private final AbstractInvokable task;
        private final Thread executerThread;
        private final String taskName;
        private final long interruptIntervalMillis;

        TaskInterrupter(Logger log, AbstractInvokable task, Thread executerThread, String taskName, long interruptIntervalMillis) {
            this.log = log;
            this.task = task;
            this.executerThread = executerThread;
            this.taskName = taskName;
            this.interruptIntervalMillis = interruptIntervalMillis;
        }

        @Override
        public void run() {
            try {
                this.executerThread.join(this.interruptIntervalMillis);
                while (this.task.shouldInterruptOnCancel() && this.executerThread.isAlive()) {
                    StackTraceElement[] stack = this.executerThread.getStackTrace();
                    StringBuilder bld = new StringBuilder();
                    for (StackTraceElement e : stack) {
                        bld.append(e).append('\n');
                    }
                    this.log.warn("Task '{}' did not react to cancelling signal for {} seconds, but is stuck in method:\n {}", new Object[]{this.taskName, this.interruptIntervalMillis / 1000L, bld});
                    this.executerThread.interrupt();
                    try {
                        this.executerThread.join(this.interruptIntervalMillis);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (Throwable t) {
                ExceptionUtils.rethrowIfFatalError((Throwable)t);
                this.log.error("Error in the task canceler for task {}.", (Object)this.taskName, (Object)t);
            }
        }
    }

    private static class TaskCanceler
    implements Runnable {
        private final Logger logger;
        private final AbstractInvokable invokable;
        private final Thread executer;
        private final String taskName;
        private final ResultPartition[] producedPartitions;
        private final SingleInputGate[] inputGates;

        public TaskCanceler(Logger logger, AbstractInvokable invokable, Thread executer, String taskName, ResultPartition[] producedPartitions, SingleInputGate[] inputGates) {
            this.logger = logger;
            this.invokable = invokable;
            this.executer = executer;
            this.taskName = taskName;
            this.producedPartitions = producedPartitions;
            this.inputGates = inputGates;
        }

        @Override
        public void run() {
            try {
                try {
                    this.invokable.cancel();
                }
                catch (Throwable t) {
                    ExceptionUtils.rethrowIfFatalError((Throwable)t);
                    this.logger.error("Error while canceling the task {}.", (Object)this.taskName, (Object)t);
                }
                for (ResultPartition partition : this.producedPartitions) {
                    try {
                        partition.destroyBufferPool();
                    }
                    catch (Throwable t) {
                        ExceptionUtils.rethrowIfFatalError((Throwable)t);
                        LOG.error("Failed to release result partition buffer pool for task {}.", (Object)this.taskName, (Object)t);
                    }
                }
                for (SingleInputGate inputGate : this.inputGates) {
                    try {
                        inputGate.releaseAllResources();
                    }
                    catch (Throwable t) {
                        ExceptionUtils.rethrowIfFatalError((Throwable)t);
                        LOG.error("Failed to release input gate for task {}.", (Object)this.taskName, (Object)t);
                    }
                }
                if (this.invokable.shouldInterruptOnCancel()) {
                    this.executer.interrupt();
                }
            }
            catch (Throwable t) {
                ExceptionUtils.rethrowIfFatalError((Throwable)t);
                this.logger.error("Error in the task canceler for task {}.", (Object)this.taskName, (Object)t);
            }
        }
    }
}

