/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.io.IOException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.runtime.state.KeyGroupPartitioner;
import org.apache.flink.runtime.state.StateSnapshotKeyGroupReader;
import org.apache.flink.runtime.state.heap.StateTable;

class StateTableByKeyGroupReaders {
    StateTableByKeyGroupReaders() {
    }

    static <K, N, S> StateSnapshotKeyGroupReader readerForVersion(StateTable<K, N, S> stateTable, int version) {
        switch (version) {
            case 1: {
                return new StateTableByKeyGroupReaderV1<K, N, S>(stateTable);
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return StateTableByKeyGroupReaders.createV2PlusReader(stateTable);
            }
        }
        throw new IllegalArgumentException("Unknown version: " + version);
    }

    private static <K, N, S> StateSnapshotKeyGroupReader createV2PlusReader(StateTable<K, N, S> stateTable) {
        TypeSerializer keySerializer = stateTable.keyContext.getKeySerializer();
        TypeSerializer namespaceSerializer = stateTable.getNamespaceSerializer();
        TypeSerializer stateSerializer = stateTable.getStateSerializer();
        Tuple3 buffer = new Tuple3();
        return KeyGroupPartitioner.createKeyGroupPartitionReader(in -> {
            buffer.f0 = namespaceSerializer.deserialize(in);
            buffer.f1 = keySerializer.deserialize(in);
            buffer.f2 = stateSerializer.deserialize(in);
            return buffer;
        }, (element, keyGroupId1) -> stateTable.put(element.f1, keyGroupId1, element.f0, element.f2));
    }

    static final class StateTableByKeyGroupReaderV1<K, N, S>
    implements StateSnapshotKeyGroupReader {
        protected final StateTable<K, N, S> stateTable;

        StateTableByKeyGroupReaderV1(StateTable<K, N, S> stateTable) {
            this.stateTable = stateTable;
        }

        @Override
        public void readMappingsInKeyGroup(@Nonnull DataInputView inView, @Nonnegative int keyGroupId) throws IOException {
            if (inView.readByte() == 0) {
                return;
            }
            TypeSerializer keySerializer = this.stateTable.keyContext.getKeySerializer();
            TypeSerializer<N> namespaceSerializer = this.stateTable.getNamespaceSerializer();
            TypeSerializer<S> stateSerializer = this.stateTable.getStateSerializer();
            int numNamespaces = inView.readInt();
            for (int k = 0; k < numNamespaces; ++k) {
                Object namespace = namespaceSerializer.deserialize(inView);
                int numEntries = inView.readInt();
                for (int l = 0; l < numEntries; ++l) {
                    Object key = keySerializer.deserialize(inView);
                    Object state = stateSerializer.deserialize(inView);
                    this.stateTable.put(key, keyGroupId, namespace, state);
                }
            }
        }
    }
}

