/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.taskmanager;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.util.Preconditions;

public class TaskManagerMetricsInfo {
    public static final String FIELD_NAME_HEAP_USED = "heapUsed";
    public static final String FIELD_NAME_HEAP_COMMITTED = "heapCommitted";
    public static final String FIELD_NAME_HEAP_MAX = "heapMax";
    public static final String FIELD_NAME_NON_HEAP_USED = "nonHeapUsed";
    public static final String FIELD_NAME_NON_HEAP_COMMITTED = "nonHeapCommitted";
    public static final String FIELD_NAME_NON_HEAP_MAX = "nonHeapMax";
    public static final String FIELD_NAME_DIRECT_COUNT = "directCount";
    public static final String FIELD_NAME_DIRECT_USED = "directUsed";
    public static final String FIELD_NAME_DIRECT_MAX = "directMax";
    public static final String FIELD_NAME_MAPPED_COUNT = "mappedCount";
    public static final String FIELD_NAME_MAPPED_USED = "mappedUsed";
    public static final String FIELD_NAME_MAPPED_MAX = "mappedMax";
    public static final String FIELD_NAME_NETWORK_MEMORY_SEGMENTS_AVAILABLE = "memorySegmentsAvailable";
    public static final String FIELD_NAME_NETWORK_MEMROY_SEGMENTS_TOTAL = "memorySegmentsTotal";
    public static final String FIELD_NAME_GARBAGE_COLLECTORS = "garbageCollectors";
    @JsonProperty(value="heapUsed")
    private final long heapUsed;
    @JsonProperty(value="heapCommitted")
    private final long heapCommitted;
    @JsonProperty(value="heapMax")
    private final long heapMax;
    @JsonProperty(value="nonHeapUsed")
    private final long nonHeapUsed;
    @JsonProperty(value="nonHeapCommitted")
    private final long nonHeapCommitted;
    @JsonProperty(value="nonHeapMax")
    private final long nonHeapMax;
    @JsonProperty(value="directCount")
    private final long directCount;
    @JsonProperty(value="directUsed")
    private final long directUsed;
    @JsonProperty(value="directMax")
    private final long directMax;
    @JsonProperty(value="mappedCount")
    private final long mappedCount;
    @JsonProperty(value="mappedUsed")
    private final long mappedUsed;
    @JsonProperty(value="mappedMax")
    private final long mappedMax;
    @JsonProperty(value="memorySegmentsAvailable")
    private final long memorySegmentsAvailable;
    @JsonProperty(value="memorySegmentsTotal")
    private final long memorySegmentsTotal;
    @JsonProperty(value="garbageCollectors")
    private final List<GarbageCollectorInfo> garbageCollectorsInfo;

    @JsonCreator
    public TaskManagerMetricsInfo(@JsonProperty(value="heapUsed") long heapUsed, @JsonProperty(value="heapCommitted") long heapCommitted, @JsonProperty(value="heapMax") long heapMax, @JsonProperty(value="nonHeapUsed") long nonHeapUsed, @JsonProperty(value="nonHeapCommitted") long nonHeapCommitted, @JsonProperty(value="nonHeapMax") long nonHeapMax, @JsonProperty(value="directCount") long directCount, @JsonProperty(value="directUsed") long directUsed, @JsonProperty(value="directMax") long directMax, @JsonProperty(value="mappedCount") long mappedCount, @JsonProperty(value="mappedUsed") long mappedUsed, @JsonProperty(value="mappedMax") long mappedMax, @JsonProperty(value="memorySegmentsAvailable") long memorySegmentsAvailable, @JsonProperty(value="memorySegmentsTotal") long memorySegmentsTotal, @JsonProperty(value="garbageCollectors") List<GarbageCollectorInfo> garbageCollectorsInfo) {
        this.heapUsed = heapUsed;
        this.heapCommitted = heapCommitted;
        this.heapMax = heapMax;
        this.nonHeapUsed = nonHeapUsed;
        this.nonHeapCommitted = nonHeapCommitted;
        this.nonHeapMax = nonHeapMax;
        this.directCount = directCount;
        this.directUsed = directUsed;
        this.directMax = directMax;
        this.mappedCount = mappedCount;
        this.mappedUsed = mappedUsed;
        this.mappedMax = mappedMax;
        this.memorySegmentsAvailable = memorySegmentsAvailable;
        this.memorySegmentsTotal = memorySegmentsTotal;
        this.garbageCollectorsInfo = (List)Preconditions.checkNotNull(garbageCollectorsInfo);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskManagerMetricsInfo that = (TaskManagerMetricsInfo)o;
        return this.heapUsed == that.heapUsed && this.heapCommitted == that.heapCommitted && this.heapMax == that.heapMax && this.nonHeapUsed == that.nonHeapUsed && this.nonHeapCommitted == that.nonHeapCommitted && this.nonHeapMax == that.nonHeapMax && this.directCount == that.directCount && this.directUsed == that.directUsed && this.directMax == that.directMax && this.mappedCount == that.mappedCount && this.mappedUsed == that.mappedUsed && this.mappedMax == that.mappedMax && this.memorySegmentsAvailable == that.memorySegmentsAvailable && this.memorySegmentsTotal == that.memorySegmentsTotal && Objects.equals(this.garbageCollectorsInfo, that.garbageCollectorsInfo);
    }

    public int hashCode() {
        return Objects.hash(this.heapUsed, this.heapCommitted, this.heapMax, this.nonHeapUsed, this.nonHeapCommitted, this.nonHeapMax, this.directCount, this.directUsed, this.directMax, this.mappedCount, this.mappedUsed, this.mappedMax, this.memorySegmentsAvailable, this.memorySegmentsTotal, this.garbageCollectorsInfo);
    }

    public static TaskManagerMetricsInfo empty() {
        return new TaskManagerMetricsInfo(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, Collections.emptyList());
    }

    public static class GarbageCollectorInfo {
        public static final String FIELD_NAME_NAME = "name";
        public static final String FIELD_NAME_COUNT = "count";
        public static final String FIELD_NAME_TIME = "time";
        @JsonProperty(value="name")
        private final String name;
        @JsonProperty(value="count")
        private final long count;
        @JsonProperty(value="time")
        private final long time;

        @JsonCreator
        public GarbageCollectorInfo(@JsonProperty(value="name") String name, @JsonProperty(value="count") long count, @JsonProperty(value="time") long time) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.count = count;
            this.time = time;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GarbageCollectorInfo that = (GarbageCollectorInfo)o;
            return this.count == that.count && this.time == that.time && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.count, this.time);
        }
    }
}

