/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.checkpoints;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.flink.runtime.checkpoint.AbstractCheckpointStats;
import org.apache.flink.runtime.checkpoint.CheckpointStatsCounts;
import org.apache.flink.runtime.checkpoint.CheckpointStatsHistory;
import org.apache.flink.runtime.checkpoint.CheckpointStatsSnapshot;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStats;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStatsSummary;
import org.apache.flink.runtime.checkpoint.FailedCheckpointStats;
import org.apache.flink.runtime.checkpoint.MinMaxAvgStats;
import org.apache.flink.runtime.checkpoint.RestoredCheckpointStats;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.rest.handler.legacy.AbstractExecutionGraphRequestHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.JsonFactory;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.runtime.webmonitor.history.JsonArchivist;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.util.FlinkException;

public class CheckpointStatsHandler
extends AbstractExecutionGraphRequestHandler {
    private static final String CHECKPOINT_STATS_REST_PATH = "/jobs/:jobid/checkpoints";

    public CheckpointStatsHandler(ExecutionGraphCache executionGraphHolder, Executor executor) {
        super(executionGraphHolder, executor);
    }

    @Override
    public String[] getPaths() {
        return new String[]{CHECKPOINT_STATS_REST_PATH};
    }

    @Override
    public CompletableFuture<String> handleRequest(AccessExecutionGraph graph, Map<String, String> params) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return CheckpointStatsHandler.createCheckpointStatsJson(graph);
            }
            catch (IOException e) {
                throw new CompletionException(new FlinkException("Could not create checkpoint stats json.", (Throwable)e));
            }
        }, this.executor);
    }

    private static String createCheckpointStatsJson(AccessExecutionGraph graph) throws IOException {
        StringWriter writer = new StringWriter();
        JsonGenerator gen = JsonFactory.JACKSON_FACTORY.createGenerator((Writer)writer);
        CheckpointStatsSnapshot snapshot = graph.getCheckpointStatsSnapshot();
        if (snapshot == null) {
            return "{}";
        }
        gen.writeStartObject();
        CheckpointStatsHandler.writeCounts(gen, snapshot.getCounts());
        CheckpointStatsHandler.writeSummary(gen, snapshot.getSummaryStats());
        CheckpointStatsHistory history = snapshot.getHistory();
        CheckpointStatsHandler.writeLatestCheckpoints(gen, history.getLatestCompletedCheckpoint(), history.getLatestSavepoint(), history.getLatestFailedCheckpoint(), snapshot.getLatestRestoredCheckpoint());
        CheckpointStatsHandler.writeHistory(gen, snapshot.getHistory());
        gen.writeEndObject();
        gen.close();
        return writer.toString();
    }

    private static void writeCounts(JsonGenerator gen, CheckpointStatsCounts counts) throws IOException {
        gen.writeObjectFieldStart("counts");
        gen.writeNumberField("restored", counts.getNumberOfRestoredCheckpoints());
        gen.writeNumberField("total", counts.getTotalNumberOfCheckpoints());
        gen.writeNumberField("in_progress", counts.getNumberOfInProgressCheckpoints());
        gen.writeNumberField("completed", counts.getNumberOfCompletedCheckpoints());
        gen.writeNumberField("failed", counts.getNumberOfFailedCheckpoints());
        gen.writeEndObject();
    }

    private static void writeSummary(JsonGenerator gen, CompletedCheckpointStatsSummary summary) throws IOException {
        gen.writeObjectFieldStart("summary");
        gen.writeObjectFieldStart("state_size");
        CheckpointStatsHandler.writeMinMaxAvg(gen, summary.getStateSizeStats());
        gen.writeEndObject();
        gen.writeObjectFieldStart("end_to_end_duration");
        CheckpointStatsHandler.writeMinMaxAvg(gen, summary.getEndToEndDurationStats());
        gen.writeEndObject();
        gen.writeObjectFieldStart("alignment_buffered");
        CheckpointStatsHandler.writeMinMaxAvg(gen, summary.getAlignmentBufferedStats());
        gen.writeEndObject();
        gen.writeEndObject();
    }

    static void writeMinMaxAvg(JsonGenerator gen, MinMaxAvgStats minMaxAvg) throws IOException {
        gen.writeNumberField("min", minMaxAvg.getMinimum());
        gen.writeNumberField("max", minMaxAvg.getMaximum());
        gen.writeNumberField("avg", minMaxAvg.getAverage());
    }

    private static void writeLatestCheckpoints(JsonGenerator gen, @Nullable CompletedCheckpointStats completed, @Nullable CompletedCheckpointStats savepoint, @Nullable FailedCheckpointStats failed, @Nullable RestoredCheckpointStats restored) throws IOException {
        String externalPath;
        gen.writeObjectFieldStart("latest");
        if (completed != null) {
            gen.writeObjectFieldStart("completed");
            CheckpointStatsHandler.writeCheckpoint(gen, completed);
            externalPath = completed.getExternalPath();
            if (externalPath != null) {
                gen.writeStringField("external_path", completed.getExternalPath());
            }
            gen.writeEndObject();
        }
        if (savepoint != null) {
            gen.writeObjectFieldStart("savepoint");
            CheckpointStatsHandler.writeCheckpoint(gen, savepoint);
            externalPath = savepoint.getExternalPath();
            if (externalPath != null) {
                gen.writeStringField("external_path", savepoint.getExternalPath());
            }
            gen.writeEndObject();
        }
        if (failed != null) {
            gen.writeObjectFieldStart("failed");
            CheckpointStatsHandler.writeCheckpoint(gen, failed);
            gen.writeNumberField("failure_timestamp", failed.getFailureTimestamp());
            String failureMsg = failed.getFailureMessage();
            if (failureMsg != null) {
                gen.writeStringField("failure_message", failureMsg);
            }
            gen.writeEndObject();
        }
        if (restored != null) {
            gen.writeObjectFieldStart("restored");
            gen.writeNumberField("id", restored.getCheckpointId());
            gen.writeNumberField("restore_timestamp", restored.getRestoreTimestamp());
            gen.writeBooleanField("is_savepoint", restored.getProperties().isSavepoint());
            externalPath = restored.getExternalPath();
            if (externalPath != null) {
                gen.writeStringField("external_path", externalPath);
            }
            gen.writeEndObject();
        }
        gen.writeEndObject();
    }

    private static void writeCheckpoint(JsonGenerator gen, AbstractCheckpointStats checkpoint) throws IOException {
        gen.writeNumberField("id", checkpoint.getCheckpointId());
        gen.writeNumberField("trigger_timestamp", checkpoint.getTriggerTimestamp());
        gen.writeNumberField("latest_ack_timestamp", checkpoint.getLatestAckTimestamp());
        gen.writeNumberField("state_size", checkpoint.getStateSize());
        gen.writeNumberField("end_to_end_duration", checkpoint.getEndToEndDuration());
        gen.writeNumberField("alignment_buffered", checkpoint.getAlignmentBuffered());
    }

    private static void writeHistory(JsonGenerator gen, CheckpointStatsHistory history) throws IOException {
        gen.writeArrayFieldStart("history");
        for (AbstractCheckpointStats checkpoint : history.getCheckpoints()) {
            gen.writeStartObject();
            gen.writeNumberField("id", checkpoint.getCheckpointId());
            gen.writeStringField("status", checkpoint.getStatus().toString());
            gen.writeBooleanField("is_savepoint", checkpoint.getProperties().isSavepoint());
            gen.writeNumberField("trigger_timestamp", checkpoint.getTriggerTimestamp());
            gen.writeNumberField("latest_ack_timestamp", checkpoint.getLatestAckTimestamp());
            gen.writeNumberField("state_size", checkpoint.getStateSize());
            gen.writeNumberField("end_to_end_duration", checkpoint.getEndToEndDuration());
            gen.writeNumberField("alignment_buffered", checkpoint.getAlignmentBuffered());
            gen.writeNumberField("num_subtasks", checkpoint.getNumberOfSubtasks());
            gen.writeNumberField("num_acknowledged_subtasks", checkpoint.getNumberOfAcknowledgedSubtasks());
            if (checkpoint.getStatus().isCompleted()) {
                CompletedCheckpointStats completed = (CompletedCheckpointStats)checkpoint;
                String externalPath = completed.getExternalPath();
                if (externalPath != null) {
                    gen.writeStringField("external_path", externalPath);
                }
                gen.writeBooleanField("discarded", completed.isDiscarded());
            } else if (checkpoint.getStatus().isFailed()) {
                FailedCheckpointStats failed = (FailedCheckpointStats)checkpoint;
                gen.writeNumberField("failure_timestamp", failed.getFailureTimestamp());
                String failureMsg = failed.getFailureMessage();
                if (failureMsg != null) {
                    gen.writeStringField("failure_message", failureMsg);
                }
            }
            gen.writeEndObject();
        }
        gen.writeEndArray();
    }

    public static class CheckpointStatsJsonArchivist
    implements JsonArchivist {
        @Override
        public Collection<ArchivedJson> archiveJsonWithPath(AccessExecutionGraph graph) throws IOException {
            String json = CheckpointStatsHandler.createCheckpointStatsJson(graph);
            String path = CheckpointStatsHandler.CHECKPOINT_STATS_REST_PATH.replace(":jobid", graph.getJobID().toString());
            return Collections.singletonList(new ArchivedJson(path, json));
        }
    }
}

