/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.rest.handler.legacy.AbstractSubtaskAttemptRequestHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.JsonFactory;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.util.MutableIOMetrics;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.runtime.webmonitor.history.JsonArchivist;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.util.FlinkException;

public class SubtaskExecutionAttemptDetailsHandler
extends AbstractSubtaskAttemptRequestHandler {
    public static final String PARAMETER_SUBTASK_INDEX = "subtasknum";
    private static final String SUBTASK_ATTEMPT_DETAILS_REST_PATH = "/jobs/:jobid/vertices/:vertexid/subtasks/:subtasknum/attempts/:attempt";
    private final MetricFetcher fetcher;

    public SubtaskExecutionAttemptDetailsHandler(ExecutionGraphCache executionGraphHolder, Executor executor, MetricFetcher fetcher) {
        super(executionGraphHolder, executor);
        this.fetcher = fetcher;
    }

    @Override
    public String[] getPaths() {
        return new String[]{SUBTASK_ATTEMPT_DETAILS_REST_PATH};
    }

    @Override
    public CompletableFuture<String> handleRequest(AccessExecution execAttempt, Map<String, String> params) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return SubtaskExecutionAttemptDetailsHandler.createAttemptDetailsJson(execAttempt, (String)params.get("jobid"), (String)params.get("vertexid"), this.fetcher);
            }
            catch (IOException e) {
                throw new CompletionException(new FlinkException("Could not create attempt details json.", (Throwable)e));
            }
        }, this.executor);
    }

    public static String createAttemptDetailsJson(AccessExecution execAttempt, String jobID, String vertexID, @Nullable MetricFetcher fetcher) throws IOException {
        long endTime;
        StringWriter writer = new StringWriter();
        JsonGenerator gen = JsonFactory.JACKSON_FACTORY.createGenerator((Writer)writer);
        ExecutionState status = execAttempt.getState();
        long now = System.currentTimeMillis();
        TaskManagerLocation location = execAttempt.getAssignedResourceLocation();
        String locationString = location == null ? "(unassigned)" : location.getHostname();
        long startTime = execAttempt.getStateTimestamp(ExecutionState.DEPLOYING);
        if (startTime == 0L) {
            startTime = -1L;
        }
        long l = endTime = status.isTerminal() ? execAttempt.getStateTimestamp(status) : -1L;
        long duration = startTime > 0L ? (endTime > 0L ? endTime : now) - startTime : -1L;
        gen.writeStartObject();
        gen.writeNumberField("subtask", execAttempt.getParallelSubtaskIndex());
        gen.writeStringField("status", status.name());
        gen.writeNumberField("attempt", execAttempt.getAttemptNumber());
        gen.writeStringField("host", locationString);
        gen.writeNumberField("start-time", startTime);
        gen.writeNumberField("end-time", endTime);
        gen.writeNumberField("duration", duration);
        MutableIOMetrics counts = new MutableIOMetrics();
        counts.addIOMetrics(execAttempt, fetcher, jobID, vertexID);
        counts.writeIOMetricsAsJson(gen);
        gen.writeEndObject();
        gen.close();
        return writer.toString();
    }

    public static class SubtaskExecutionAttemptDetailsJsonArchivist
    implements JsonArchivist {
        @Override
        public Collection<ArchivedJson> archiveJsonWithPath(AccessExecutionGraph graph) throws IOException {
            ArrayList<ArchivedJson> archive = new ArrayList<ArchivedJson>();
            for (AccessExecutionJobVertex accessExecutionJobVertex : graph.getAllVertices().values()) {
                for (AccessExecutionVertex subtask : accessExecutionJobVertex.getTaskVertices()) {
                    String curAttemptJson = SubtaskExecutionAttemptDetailsHandler.createAttemptDetailsJson(subtask.getCurrentExecutionAttempt(), graph.getJobID().toString(), accessExecutionJobVertex.getJobVertexId().toString(), null);
                    String curAttemptPath1 = "/jobs/:jobid/vertices/:vertexid/subtasks/:subtasknum".replace(":jobid", graph.getJobID().toString()).replace(":vertexid", accessExecutionJobVertex.getJobVertexId().toString()).replace(":subtasknum", String.valueOf(subtask.getParallelSubtaskIndex()));
                    String curAttemptPath2 = SubtaskExecutionAttemptDetailsHandler.SUBTASK_ATTEMPT_DETAILS_REST_PATH.replace(":jobid", graph.getJobID().toString()).replace(":vertexid", accessExecutionJobVertex.getJobVertexId().toString()).replace(":subtasknum", String.valueOf(subtask.getParallelSubtaskIndex())).replace(":attempt", String.valueOf(subtask.getCurrentExecutionAttempt().getAttemptNumber()));
                    archive.add(new ArchivedJson(curAttemptPath1, curAttemptJson));
                    archive.add(new ArchivedJson(curAttemptPath2, curAttemptJson));
                    for (int x = 0; x < subtask.getCurrentExecutionAttempt().getAttemptNumber(); ++x) {
                        AccessExecution attempt = subtask.getPriorExecutionAttempt(x);
                        String json = SubtaskExecutionAttemptDetailsHandler.createAttemptDetailsJson(attempt, graph.getJobID().toString(), accessExecutionJobVertex.getJobVertexId().toString(), null);
                        String path = SubtaskExecutionAttemptDetailsHandler.SUBTASK_ATTEMPT_DETAILS_REST_PATH.replace(":jobid", graph.getJobID().toString()).replace(":vertexid", accessExecutionJobVertex.getJobVertexId().toString()).replace(":subtasknum", String.valueOf(subtask.getParallelSubtaskIndex())).replace(":attempt", String.valueOf(attempt.getAttemptNumber()));
                        archive.add(new ArchivedJson(path, json));
                    }
                }
            }
            return archive;
        }
    }
}

