/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.metrics;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.job.metrics.AbstractMetricsHandler;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.job.metrics.TaskManagerMetricsHeaders;
import org.apache.flink.runtime.rest.messages.job.metrics.TaskManagerMetricsMessageParameters;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerIdPathParameter;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public class TaskManagerMetricsHandler
extends AbstractMetricsHandler<TaskManagerMetricsMessageParameters> {
    public TaskManagerMetricsHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> headers, MetricFetcher metricFetcher) {
        super(localRestAddress, leaderRetriever, timeout, headers, TaskManagerMetricsHeaders.getInstance(), metricFetcher);
    }

    @Override
    @Nullable
    protected MetricStore.ComponentMetricStore getComponentMetricStore(HandlerRequest<EmptyRequestBody, TaskManagerMetricsMessageParameters> request, MetricStore metricStore) {
        ResourceID taskManagerId = (ResourceID)request.getPathParameter(TaskManagerIdPathParameter.class);
        return metricStore.getTaskManagerMetricStore(taskManagerId.toString());
    }
}

