/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler;

import java.io.File;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.WebOptions;
import org.apache.flink.util.Preconditions;

public class RestHandlerConfiguration {
    private final long refreshInterval;
    private final int maxCheckpointStatisticCacheEntries;
    private final Time timeout;
    private final File webUiDir;

    public RestHandlerConfiguration(long refreshInterval, int maxCheckpointStatisticCacheEntries, Time timeout, File webUiDir) {
        Preconditions.checkArgument((refreshInterval > 0L ? 1 : 0) != 0, (Object)"The refresh interval (ms) should be larger than 0.");
        this.refreshInterval = refreshInterval;
        this.maxCheckpointStatisticCacheEntries = maxCheckpointStatisticCacheEntries;
        this.timeout = (Time)Preconditions.checkNotNull((Object)timeout);
        this.webUiDir = (File)Preconditions.checkNotNull((Object)webUiDir);
    }

    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    public int getMaxCheckpointStatisticCacheEntries() {
        return this.maxCheckpointStatisticCacheEntries;
    }

    public Time getTimeout() {
        return this.timeout;
    }

    public File getWebUiDir() {
        return this.webUiDir;
    }

    public static RestHandlerConfiguration fromConfiguration(Configuration configuration) {
        long refreshInterval = configuration.getLong(WebOptions.REFRESH_INTERVAL);
        int maxCheckpointStatisticCacheEntries = configuration.getInteger(WebOptions.CHECKPOINTS_HISTORY_SIZE);
        Time timeout = Time.milliseconds((long)configuration.getLong(WebOptions.TIMEOUT));
        String rootDir = "flink-web-ui";
        File webUiDir = new File(configuration.getString(WebOptions.TMP_DIR), "flink-web-ui");
        return new RestHandlerConfiguration(refreshInterval, maxCheckpointStatisticCacheEntries, timeout, webUiDir);
    }
}

