/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.util;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.ThreadMXBean;
import java.util.List;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.io.network.NetworkEnvironment;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.groups.JobManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MetricUtils.class);
    private static final String METRIC_GROUP_STATUS_NAME = "Status";

    private MetricUtils() {
    }

    public static JobManagerMetricGroup instantiateJobManagerMetricGroup(MetricRegistry metricRegistry, String hostname) {
        JobManagerMetricGroup jobManagerMetricGroup = new JobManagerMetricGroup(metricRegistry, hostname);
        MetricGroup statusGroup = jobManagerMetricGroup.addGroup(METRIC_GROUP_STATUS_NAME);
        MetricUtils.instantiateStatusMetrics(statusGroup);
        return jobManagerMetricGroup;
    }

    public static TaskManagerMetricGroup instantiateTaskManagerMetricGroup(MetricRegistry metricRegistry, TaskManagerLocation taskManagerLocation, NetworkEnvironment network) {
        TaskManagerMetricGroup taskManagerMetricGroup = new TaskManagerMetricGroup(metricRegistry, taskManagerLocation.getHostname(), taskManagerLocation.getResourceID().toString());
        MetricGroup statusGroup = taskManagerMetricGroup.addGroup(METRIC_GROUP_STATUS_NAME);
        MetricUtils.instantiateStatusMetrics(statusGroup);
        MetricGroup networkGroup = statusGroup.addGroup("Network");
        MetricUtils.instantiateNetworkMetrics(networkGroup, network);
        return taskManagerMetricGroup;
    }

    public static void instantiateStatusMetrics(MetricGroup metricGroup) {
        MetricGroup jvm = metricGroup.addGroup("JVM");
        MetricUtils.instantiateClassLoaderMetrics(jvm.addGroup("ClassLoader"));
        MetricUtils.instantiateGarbageCollectorMetrics(jvm.addGroup("GarbageCollector"));
        MetricUtils.instantiateMemoryMetrics(jvm.addGroup("Memory"));
        MetricUtils.instantiateThreadMetrics(jvm.addGroup("Threads"));
        MetricUtils.instantiateCPUMetrics(jvm.addGroup("CPU"));
    }

    private static void instantiateNetworkMetrics(MetricGroup metrics, final NetworkEnvironment network) {
        metrics.gauge("TotalMemorySegments", (Gauge)new Gauge<Long>(){

            public Long getValue() {
                return network.getNetworkBufferPool().getTotalNumberOfMemorySegments();
            }
        });
        metrics.gauge("AvailableMemorySegments", (Gauge)new Gauge<Long>(){

            public Long getValue() {
                return network.getNetworkBufferPool().getNumberOfAvailableMemorySegments();
            }
        });
    }

    private static void instantiateClassLoaderMetrics(MetricGroup metrics) {
        final ClassLoadingMXBean mxBean = ManagementFactory.getClassLoadingMXBean();
        metrics.gauge("ClassesLoaded", (Gauge)new Gauge<Long>(){

            public Long getValue() {
                return mxBean.getTotalLoadedClassCount();
            }
        });
        metrics.gauge("ClassesUnloaded", (Gauge)new Gauge<Long>(){

            public Long getValue() {
                return mxBean.getUnloadedClassCount();
            }
        });
    }

    private static void instantiateGarbageCollectorMetrics(MetricGroup metrics) {
        List<GarbageCollectorMXBean> garbageCollectors = ManagementFactory.getGarbageCollectorMXBeans();
        for (final GarbageCollectorMXBean garbageCollector : garbageCollectors) {
            MetricGroup gcGroup = metrics.addGroup(garbageCollector.getName());
            gcGroup.gauge("Count", (Gauge)new Gauge<Long>(){

                public Long getValue() {
                    return garbageCollector.getCollectionCount();
                }
            });
            gcGroup.gauge("Time", (Gauge)new Gauge<Long>(){

                public Long getValue() {
                    return garbageCollector.getCollectionTime();
                }
            });
        }
    }

    private static void instantiateMemoryMetrics(MetricGroup metrics) {
        final MemoryMXBean mxBean = ManagementFactory.getMemoryMXBean();
        MetricGroup heap = metrics.addGroup("Heap");
        heap.gauge("Used", (Gauge)new Gauge<Long>(){

            public Long getValue() {
                return mxBean.getHeapMemoryUsage().getUsed();
            }
        });
        heap.gauge("Committed", (Gauge)new Gauge<Long>(){

            public Long getValue() {
                return mxBean.getHeapMemoryUsage().getCommitted();
            }
        });
        heap.gauge("Max", (Gauge)new Gauge<Long>(){

            public Long getValue() {
                return mxBean.getHeapMemoryUsage().getMax();
            }
        });
        MetricGroup nonHeap = metrics.addGroup("NonHeap");
        nonHeap.gauge("Used", (Gauge)new Gauge<Long>(){

            public Long getValue() {
                return mxBean.getNonHeapMemoryUsage().getUsed();
            }
        });
        nonHeap.gauge("Committed", (Gauge)new Gauge<Long>(){

            public Long getValue() {
                return mxBean.getNonHeapMemoryUsage().getCommitted();
            }
        });
        nonHeap.gauge("Max", (Gauge)new Gauge<Long>(){

            public Long getValue() {
                return mxBean.getNonHeapMemoryUsage().getMax();
            }
        });
        MBeanServer con = ManagementFactory.getPlatformMBeanServer();
        String directBufferPoolName = "java.nio:type=BufferPool,name=direct";
        try {
            ObjectName directObjectName = new ObjectName("java.nio:type=BufferPool,name=direct");
            MetricGroup direct = metrics.addGroup("Direct");
            direct.gauge("Count", new AttributeGauge(con, directObjectName, "Count", -1L));
            direct.gauge("MemoryUsed", new AttributeGauge(con, directObjectName, "MemoryUsed", -1L));
            direct.gauge("TotalCapacity", new AttributeGauge(con, directObjectName, "TotalCapacity", -1L));
        }
        catch (MalformedObjectNameException e) {
            LOG.warn("Could not create object name {}.", (Object)"java.nio:type=BufferPool,name=direct", (Object)e);
        }
        String mappedBufferPoolName = "java.nio:type=BufferPool,name=mapped";
        try {
            ObjectName mappedObjectName = new ObjectName("java.nio:type=BufferPool,name=mapped");
            MetricGroup mapped = metrics.addGroup("Mapped");
            mapped.gauge("Count", new AttributeGauge(con, mappedObjectName, "Count", -1L));
            mapped.gauge("MemoryUsed", new AttributeGauge(con, mappedObjectName, "MemoryUsed", -1L));
            mapped.gauge("TotalCapacity", new AttributeGauge(con, mappedObjectName, "TotalCapacity", -1L));
        }
        catch (MalformedObjectNameException e) {
            LOG.warn("Could not create object name {}.", (Object)"java.nio:type=BufferPool,name=mapped", (Object)e);
        }
    }

    private static void instantiateThreadMetrics(MetricGroup metrics) {
        final ThreadMXBean mxBean = ManagementFactory.getThreadMXBean();
        metrics.gauge("Count", (Gauge)new Gauge<Integer>(){

            public Integer getValue() {
                return mxBean.getThreadCount();
            }
        });
    }

    private static void instantiateCPUMetrics(MetricGroup metrics) {
        try {
            final OperatingSystemMXBean mxBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            metrics.gauge("Load", (Gauge)new Gauge<Double>(){

                public Double getValue() {
                    return mxBean.getProcessCpuLoad();
                }
            });
            metrics.gauge("Time", (Gauge)new Gauge<Long>(){

                public Long getValue() {
                    return mxBean.getProcessCpuTime();
                }
            });
        }
        catch (Exception e) {
            LOG.warn("Cannot access com.sun.management.OperatingSystemMXBean.getProcessCpuLoad() - CPU load metrics will not be available.", (Throwable)e);
        }
    }

    private static final class AttributeGauge<T>
    implements Gauge<T> {
        private final MBeanServer server;
        private final ObjectName objectName;
        private final String attributeName;
        private final T errorValue;

        private AttributeGauge(MBeanServer server, ObjectName objectName, String attributeName, T errorValue) {
            this.server = (MBeanServer)Preconditions.checkNotNull((Object)server);
            this.objectName = (ObjectName)Preconditions.checkNotNull((Object)objectName);
            this.attributeName = (String)Preconditions.checkNotNull((Object)attributeName);
            this.errorValue = errorValue;
        }

        public T getValue() {
            try {
                return (T)this.server.getAttribute(this.objectName, this.attributeName);
            }
            catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | ReflectionException e) {
                LOG.warn("Could not read attribute {}.", (Object)this.attributeName, (Object)e);
                return this.errorValue;
            }
        }
    }
}

