/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.GenericKeyMetricGroup;
import org.apache.flink.runtime.metrics.groups.GenericMetricGroup;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public abstract class AbstractMetricGroup<A extends AbstractMetricGroup<?>>
implements MetricGroup {
    protected static final Logger LOG = LoggerFactory.getLogger(MetricGroup.class);
    protected final A parent;
    protected volatile Map<String, String> variables;
    protected final MetricRegistry registry;
    private final Map<String, Metric> metrics = new HashMap<String, Metric>();
    private final Map<String, AbstractMetricGroup> groups = new HashMap<String, AbstractMetricGroup>();
    private final String[] scopeComponents;
    private final String[] scopeStrings;
    private String logicalScopeString;
    protected QueryScopeInfo queryServiceScopeInfo;
    private volatile boolean closed;

    public AbstractMetricGroup(MetricRegistry registry, String[] scope, A parent) {
        this.registry = (MetricRegistry)Preconditions.checkNotNull((Object)registry);
        this.scopeComponents = (String[])Preconditions.checkNotNull((Object)scope);
        this.parent = parent;
        this.scopeStrings = new String[registry.getNumberReporters()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getAllVariables() {
        if (this.variables == null) {
            AbstractMetricGroup abstractMetricGroup = this;
            synchronized (abstractMetricGroup) {
                if (this.variables == null) {
                    HashMap<String, String> tmpVariables = new HashMap<String, String>();
                    this.putVariables(tmpVariables);
                    if (this.parent != null) {
                        tmpVariables.putAll(((AbstractMetricGroup)this.parent).getAllVariables());
                    }
                    this.variables = tmpVariables;
                }
            }
        }
        return this.variables;
    }

    protected void putVariables(Map<String, String> variables) {
    }

    public String getLogicalScope(CharacterFilter filter) {
        return this.getLogicalScope(filter, this.registry.getDelimiter());
    }

    public String getLogicalScope(CharacterFilter filter, char delimiter) {
        if (this.logicalScopeString == null) {
            this.logicalScopeString = this.parent == null ? this.getGroupName(filter) : ((AbstractMetricGroup)this.parent).getLogicalScope(filter, delimiter) + delimiter + this.getGroupName(filter);
        }
        return this.logicalScopeString;
    }

    protected abstract String getGroupName(CharacterFilter var1);

    public String[] getScopeComponents() {
        return this.scopeComponents;
    }

    public QueryScopeInfo getQueryServiceMetricInfo(CharacterFilter filter) {
        if (this.queryServiceScopeInfo == null) {
            this.queryServiceScopeInfo = this.createQueryServiceMetricInfo(filter);
        }
        return this.queryServiceScopeInfo;
    }

    protected abstract QueryScopeInfo createQueryServiceMetricInfo(CharacterFilter var1);

    public String getMetricIdentifier(String metricName) {
        return this.getMetricIdentifier(metricName, null);
    }

    public String getMetricIdentifier(String metricName, CharacterFilter filter) {
        return this.getMetricIdentifier(metricName, filter, -1);
    }

    public String getMetricIdentifier(String metricName, CharacterFilter filter, int reporterIndex) {
        if (this.scopeStrings.length == 0 || reporterIndex < 0 || reporterIndex >= this.scopeStrings.length) {
            String newScopeString;
            char delimiter = this.registry.getDelimiter();
            if (filter != null) {
                newScopeString = ScopeFormat.concat(filter, Character.valueOf(delimiter), this.scopeComponents);
                metricName = filter.filterCharacters(metricName);
            } else {
                newScopeString = ScopeFormat.concat(Character.valueOf(delimiter), this.scopeComponents);
            }
            return newScopeString + delimiter + metricName;
        }
        char delimiter = this.registry.getDelimiter(reporterIndex);
        if (this.scopeStrings[reporterIndex] == null) {
            this.scopeStrings[reporterIndex] = filter != null ? ScopeFormat.concat(filter, Character.valueOf(delimiter), this.scopeComponents) : ScopeFormat.concat(Character.valueOf(delimiter), this.scopeComponents);
        }
        if (filter != null) {
            metricName = filter.filterCharacters(metricName);
        }
        return this.scopeStrings[reporterIndex] + delimiter + metricName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        AbstractMetricGroup abstractMetricGroup = this;
        synchronized (abstractMetricGroup) {
            if (!this.closed) {
                this.closed = true;
                for (AbstractMetricGroup abstractMetricGroup2 : this.groups.values()) {
                    abstractMetricGroup2.close();
                }
                this.groups.clear();
                for (Map.Entry entry : this.metrics.entrySet()) {
                    this.registry.unregister((Metric)entry.getValue(), (String)entry.getKey(), this);
                }
                this.metrics.clear();
            }
        }
    }

    public final boolean isClosed() {
        return this.closed;
    }

    public Counter counter(int name) {
        return this.counter(String.valueOf(name));
    }

    public Counter counter(String name) {
        return this.counter(name, new SimpleCounter());
    }

    public <C extends Counter> C counter(int name, C counter) {
        return this.counter(String.valueOf(name), counter);
    }

    public <C extends Counter> C counter(String name, C counter) {
        this.addMetric(name, (Metric)counter);
        return counter;
    }

    public <T, G extends Gauge<T>> G gauge(int name, G gauge) {
        return this.gauge(String.valueOf(name), gauge);
    }

    public <T, G extends Gauge<T>> G gauge(String name, G gauge) {
        this.addMetric(name, (Metric)gauge);
        return gauge;
    }

    public <H extends Histogram> H histogram(int name, H histogram) {
        return this.histogram(String.valueOf(name), histogram);
    }

    public <H extends Histogram> H histogram(String name, H histogram) {
        this.addMetric(name, (Metric)histogram);
        return histogram;
    }

    public <M extends Meter> M meter(int name, M meter) {
        return this.meter(String.valueOf(name), meter);
    }

    public <M extends Meter> M meter(String name, M meter) {
        this.addMetric(name, (Metric)meter);
        return meter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMetric(String name, Metric metric) {
        if (metric == null) {
            LOG.warn("Ignoring attempted registration of a metric due to being null for name {}.", (Object)name);
            return;
        }
        AbstractMetricGroup abstractMetricGroup = this;
        synchronized (abstractMetricGroup) {
            if (!this.closed) {
                Metric prior = this.metrics.put(name, metric);
                if (prior == null) {
                    if (this.groups.containsKey(name)) {
                        LOG.warn("Name collision: Adding a metric with the same name as a metric subgroup: '" + name + "'. Metric might not get properly reported. " + Arrays.toString(this.scopeComponents));
                    }
                    this.registry.register(metric, name, this);
                } else {
                    this.metrics.put(name, prior);
                    LOG.warn("Name collision: Group already contains a Metric with the name '" + name + "'. Metric will not be reported." + Arrays.toString(this.scopeComponents));
                }
            }
        }
    }

    public MetricGroup addGroup(int name) {
        return this.addGroup(String.valueOf(name), ChildType.GENERIC);
    }

    public MetricGroup addGroup(String name) {
        return this.addGroup(name, ChildType.GENERIC);
    }

    public MetricGroup addGroup(String key, String value) {
        return super.addGroup(value, ChildType.VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractMetricGroup<?> addGroup(String name, ChildType childType) {
        AbstractMetricGroup abstractMetricGroup = this;
        synchronized (abstractMetricGroup) {
            if (!this.closed) {
                GenericMetricGroup newGroup;
                AbstractMetricGroup prior;
                if (this.metrics.containsKey(name)) {
                    LOG.warn("Name collision: Adding a metric subgroup with the same name as an existing metric: '" + name + "'. Metric might not get properly reported. " + Arrays.toString(this.scopeComponents));
                }
                if ((prior = this.groups.put(name, newGroup = this.createChildGroup(name, childType))) == null) {
                    return newGroup;
                }
                this.groups.put(name, prior);
                return prior;
            }
            GenericMetricGroup closedGroup = new GenericMetricGroup(this.registry, this, name);
            closedGroup.close();
            return closedGroup;
        }
    }

    protected GenericMetricGroup createChildGroup(String name, ChildType childType) {
        switch (childType) {
            case KEY: {
                return new GenericKeyMetricGroup(this.registry, this, name);
            }
        }
        return new GenericMetricGroup(this.registry, this, name);
    }

    protected static enum ChildType {
        KEY,
        VALUE,
        GENERIC;

    }
}

