/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.function.BiConsumerWithException;

public enum RescalingBehaviour implements BiConsumerWithException<JobVertex, Integer, FlinkException>
{
    STRICT{

        public void accept(JobVertex jobVertex, Integer newParallelism) throws FlinkException {
            if (jobVertex.getMaxParallelism() < newParallelism) {
                throw new FlinkException("Cannot rescale vertex " + jobVertex.getName() + " because its maximum parallelism " + jobVertex.getMaxParallelism() + " is smaller than the new parallelism " + newParallelism + '.');
            }
            jobVertex.setParallelism(newParallelism);
        }
    }
    ,
    RELAXED{

        public void accept(JobVertex jobVertex, Integer newParallelism) {
            jobVertex.setParallelism(Math.min(jobVertex.getMaxParallelism(), newParallelism));
        }
    };

}

