/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nullable;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.io.network.api.serialization.RecordSerializer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;

public class SpanningRecordSerializer<T extends IOReadableWritable>
implements RecordSerializer<T> {
    private static final boolean CHECKED = false;
    private final DataOutputSerializer serializationBuffer = new DataOutputSerializer(128);
    private ByteBuffer dataBuffer;
    private final ByteBuffer lengthBuffer = ByteBuffer.allocate(4);
    @Nullable
    private BufferBuilder targetBuffer;

    public SpanningRecordSerializer() {
        this.lengthBuffer.order(ByteOrder.BIG_ENDIAN);
        this.dataBuffer = this.serializationBuffer.wrapAsByteBuffer();
        this.lengthBuffer.position(4);
    }

    @Override
    public RecordSerializer.SerializationResult addRecord(T record) throws IOException {
        this.serializationBuffer.clear();
        this.lengthBuffer.clear();
        record.write((DataOutputView)this.serializationBuffer);
        int len = this.serializationBuffer.length();
        this.lengthBuffer.putInt(0, len);
        this.dataBuffer = this.serializationBuffer.wrapAsByteBuffer();
        if (this.targetBuffer != null) {
            this.targetBuffer.append(this.lengthBuffer);
            this.targetBuffer.append(this.dataBuffer);
            this.targetBuffer.commit();
        }
        return this.getSerializationResult();
    }

    @Override
    public RecordSerializer.SerializationResult continueWritingWithNextBufferBuilder(BufferBuilder buffer) throws IOException {
        RecordSerializer.SerializationResult result;
        this.targetBuffer = buffer;
        boolean mustCommit = false;
        if (this.lengthBuffer.hasRemaining()) {
            this.targetBuffer.append(this.lengthBuffer);
            mustCommit = true;
        }
        if (this.dataBuffer.hasRemaining()) {
            this.targetBuffer.append(this.dataBuffer);
            mustCommit = true;
        }
        if (mustCommit) {
            this.targetBuffer.commit();
        }
        if ((result = this.getSerializationResult()).isFullRecord()) {
            this.serializationBuffer.clear();
            this.serializationBuffer.pruneBuffer();
            this.dataBuffer = this.serializationBuffer.wrapAsByteBuffer();
        }
        return result;
    }

    private RecordSerializer.SerializationResult getSerializationResult() {
        if (this.dataBuffer.hasRemaining() || this.lengthBuffer.hasRemaining()) {
            return RecordSerializer.SerializationResult.PARTIAL_RECORD_MEMORY_SEGMENT_FULL;
        }
        return !this.targetBuffer.isFull() ? RecordSerializer.SerializationResult.FULL_RECORD : RecordSerializer.SerializationResult.FULL_RECORD_MEMORY_SEGMENT_FULL;
    }

    @Override
    public void clear() {
        this.targetBuffer = null;
    }

    @Override
    public boolean hasSerializedData() {
        return this.lengthBuffer.hasRemaining() || this.dataBuffer.hasRemaining();
    }
}

