/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability.nonha.standalone;

import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.highavailability.nonha.AbstractNonHaServices;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderelection.StandaloneLeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.leaderretrieval.StandaloneLeaderRetrievalService;
import org.apache.flink.util.Preconditions;

public class StandaloneHaServices
extends AbstractNonHaServices {
    private static final String RESOURCE_MANAGER_RPC_ENDPOINT_NAME = "resource_manager";
    private final String resourceManagerAddress;
    private final String dispatcherAddress;
    private final String jobManagerAddress;
    private final String webMonitorAddress;

    public StandaloneHaServices(String resourceManagerAddress, String dispatcherAddress, String jobManagerAddress, String webMonitorAddress) {
        this.resourceManagerAddress = (String)Preconditions.checkNotNull((Object)resourceManagerAddress, (String)"resourceManagerAddress");
        this.dispatcherAddress = (String)Preconditions.checkNotNull((Object)dispatcherAddress, (String)"dispatcherAddress");
        this.jobManagerAddress = (String)Preconditions.checkNotNull((Object)jobManagerAddress, (String)"jobManagerAddress");
        this.webMonitorAddress = (String)Preconditions.checkNotNull((Object)webMonitorAddress, (String)webMonitorAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaderRetrievalService getResourceManagerLeaderRetriever() {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            return new StandaloneLeaderRetrievalService(this.resourceManagerAddress, DEFAULT_LEADER_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaderRetrievalService getDispatcherLeaderRetriever() {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            return new StandaloneLeaderRetrievalService(this.dispatcherAddress, DEFAULT_LEADER_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaderElectionService getResourceManagerLeaderElectionService() {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            return new StandaloneLeaderElectionService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaderElectionService getDispatcherLeaderElectionService() {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            return new StandaloneLeaderElectionService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaderRetrievalService getJobManagerLeaderRetriever(JobID jobID) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            return new StandaloneLeaderRetrievalService(this.jobManagerAddress, DEFAULT_LEADER_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaderRetrievalService getJobManagerLeaderRetriever(JobID jobID, String defaultJobManagerAddress) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            return new StandaloneLeaderRetrievalService(defaultJobManagerAddress, DEFAULT_LEADER_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaderElectionService getJobManagerLeaderElectionService(JobID jobID) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            return new StandaloneLeaderElectionService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaderRetrievalService getWebMonitorLeaderRetriever() {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            return new StandaloneLeaderRetrievalService(this.webMonitorAddress, DEFAULT_LEADER_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaderElectionService getWebMonitorLeaderElectionService() {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            return new StandaloneLeaderElectionService();
        }
    }
}

