/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.shaded.curator.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.shaded.curator.org.apache.curator.framework.api.ErrorListenerPathable;
import org.apache.flink.shaded.curator.org.apache.curator.framework.recipes.shared.SharedCount;
import org.apache.flink.shaded.curator.org.apache.curator.framework.recipes.shared.VersionedValue;
import org.apache.flink.shaded.curator.org.apache.curator.framework.state.ConnectionState;
import org.apache.flink.shaded.curator.org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperCheckpointIDCounter
implements CheckpointIDCounter {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperCheckpointIDCounter.class);
    private final CuratorFramework client;
    private final String counterPath;
    private final SharedCount sharedCount;
    private final SharedCountConnectionStateListener connStateListener = new SharedCountConnectionStateListener();
    private final Object startStopLock = new Object();
    private boolean isStarted;

    public ZooKeeperCheckpointIDCounter(CuratorFramework client, String counterPath) {
        this.client = (CuratorFramework)Preconditions.checkNotNull((Object)client, (String)"Curator client");
        this.counterPath = (String)Preconditions.checkNotNull((Object)counterPath, (String)"Counter path");
        this.sharedCount = new SharedCount(client, counterPath, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        Object object = this.startStopLock;
        synchronized (object) {
            if (!this.isStarted) {
                this.sharedCount.start();
                this.client.getConnectionStateListenable().addListener(this.connStateListener);
                this.isStarted = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(JobStatus jobStatus) throws Exception {
        Object object = this.startStopLock;
        synchronized (object) {
            if (this.isStarted) {
                LOG.info("Shutting down.");
                this.sharedCount.close();
                this.client.getConnectionStateListenable().removeListener(this.connStateListener);
                if (jobStatus.isGloballyTerminalState()) {
                    LOG.info("Removing {} from ZooKeeper", (Object)this.counterPath);
                    ((ErrorListenerPathable)this.client.delete().deletingChildrenIfNeeded().inBackground()).forPath(this.counterPath);
                }
                this.isStarted = false;
            }
        }
    }

    @Override
    public long getAndIncrement() throws Exception {
        int newCount;
        VersionedValue<Integer> current;
        do {
            ConnectionState connState;
            if ((connState = this.connStateListener.getLastState()) != null) {
                throw new IllegalStateException("Connection state: " + (Object)((Object)connState));
            }
            current = this.sharedCount.getVersionedValue();
            newCount = current.getValue() + 1;
            if (newCount >= 0) continue;
            throw new Exception("Checkpoint counter overflow. ZooKeeper checkpoint counter only supports checkpoints Ids up to 2147483647");
        } while (!this.sharedCount.trySetCount(current, newCount));
        return current.getValue().intValue();
    }

    @Override
    public void setCount(long newId) throws Exception {
        ConnectionState connState = this.connStateListener.getLastState();
        if (connState != null) {
            throw new IllegalStateException("Connection state: " + (Object)((Object)connState));
        }
        if (newId > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("ZooKeeper checkpoint counter only supports checkpoints Ids up to 2147483647, but given value is" + newId);
        }
        this.sharedCount.setCount((int)newId);
    }

    private static class SharedCountConnectionStateListener
    implements ConnectionStateListener {
        private volatile ConnectionState lastState;

        private SharedCountConnectionStateListener() {
        }

        @Override
        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            if (newState == ConnectionState.SUSPENDED || newState == ConnectionState.LOST) {
                this.lastState = newState;
            }
        }

        private ConnectionState getLastState() {
            return this.lastState;
        }
    }
}

