/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;

public class MinMaxAvgStats
implements Serializable {
    private static final long serialVersionUID = 1769601903483446707L;
    private long min;
    private long max;
    private long sum;
    private long count;

    MinMaxAvgStats() {
    }

    private MinMaxAvgStats(long min, long max, long sum, long count) {
        this.min = min;
        this.max = max;
        this.sum = sum;
        this.count = count;
    }

    void add(long value) {
        if (value >= 0L) {
            if (this.count > 0L) {
                this.min = Math.min(this.min, value);
                this.max = Math.max(this.max, value);
            } else {
                this.min = value;
                this.max = value;
            }
            ++this.count;
            this.sum += value;
        }
    }

    MinMaxAvgStats createSnapshot() {
        return new MinMaxAvgStats(this.min, this.max, this.sum, this.count);
    }

    public long getMinimum() {
        return this.min;
    }

    public long getMaximum() {
        return this.max;
    }

    public long getSum() {
        return this.sum;
    }

    public long getCount() {
        return this.count;
    }

    public long getAverage() {
        if (this.count == 0L) {
            return 0L;
        }
        return this.sum / this.count;
    }
}

