/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Objects;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.util.Preconditions;

public class RegisteredBroadcastBackendStateMetaInfo<K, V> {
    private final String name;
    private final OperatorStateHandle.Mode assignmentMode;
    private final TypeSerializer<K> keySerializer;
    private final TypeSerializer<V> valueSerializer;

    public RegisteredBroadcastBackendStateMetaInfo(String name, OperatorStateHandle.Mode assignmentMode, TypeSerializer<K> keySerializer, TypeSerializer<V> valueSerializer) {
        Preconditions.checkArgument((assignmentMode != null && assignmentMode == OperatorStateHandle.Mode.BROADCAST ? 1 : 0) != 0);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.assignmentMode = assignmentMode;
        this.keySerializer = (TypeSerializer)Preconditions.checkNotNull(keySerializer);
        this.valueSerializer = (TypeSerializer)Preconditions.checkNotNull(valueSerializer);
    }

    public RegisteredBroadcastBackendStateMetaInfo(RegisteredBroadcastBackendStateMetaInfo<K, V> copy) {
        Preconditions.checkNotNull(copy);
        this.name = copy.name;
        this.assignmentMode = copy.assignmentMode;
        this.keySerializer = copy.keySerializer.duplicate();
        this.valueSerializer = copy.valueSerializer.duplicate();
    }

    public RegisteredBroadcastBackendStateMetaInfo<K, V> deepCopy() {
        return new RegisteredBroadcastBackendStateMetaInfo<K, V>(this);
    }

    public String getName() {
        return this.name;
    }

    public TypeSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public TypeSerializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    public OperatorStateHandle.Mode getAssignmentMode() {
        return this.assignmentMode;
    }

    public Snapshot<K, V> snapshot() {
        return new Snapshot(this.name, this.assignmentMode, this.keySerializer.duplicate(), this.valueSerializer.duplicate(), this.keySerializer.snapshotConfiguration(), this.valueSerializer.snapshotConfiguration());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RegisteredBroadcastBackendStateMetaInfo)) {
            return false;
        }
        RegisteredBroadcastBackendStateMetaInfo other = (RegisteredBroadcastBackendStateMetaInfo)obj;
        return Objects.equals(this.name, other.getName()) && Objects.equals((Object)this.assignmentMode, (Object)other.getAssignmentMode()) && Objects.equals(this.keySerializer, other.getKeySerializer()) && Objects.equals(this.valueSerializer, other.getValueSerializer());
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.assignmentMode.hashCode();
        result = 31 * result + this.keySerializer.hashCode();
        result = 31 * result + this.valueSerializer.hashCode();
        return result;
    }

    public String toString() {
        return "RegisteredBroadcastBackendStateMetaInfo{name='" + this.name + '\'' + ", keySerializer=" + this.keySerializer + ", valueSerializer=" + this.valueSerializer + ", assignmentMode=" + (Object)((Object)this.assignmentMode) + '}';
    }

    public static class Snapshot<K, V> {
        private String name;
        private OperatorStateHandle.Mode assignmentMode;
        private TypeSerializer<K> keySerializer;
        private TypeSerializer<V> valueSerializer;
        private TypeSerializerConfigSnapshot keySerializerConfigSnapshot;
        private TypeSerializerConfigSnapshot valueSerializerConfigSnapshot;

        Snapshot() {
        }

        private Snapshot(String name, OperatorStateHandle.Mode assignmentMode, TypeSerializer<K> keySerializer, TypeSerializer<V> valueSerializer, TypeSerializerConfigSnapshot keySerializerConfigSnapshot, TypeSerializerConfigSnapshot valueSerializerConfigSnapshot) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.assignmentMode = (OperatorStateHandle.Mode)((Object)Preconditions.checkNotNull((Object)((Object)assignmentMode)));
            this.keySerializer = (TypeSerializer)Preconditions.checkNotNull(keySerializer);
            this.valueSerializer = (TypeSerializer)Preconditions.checkNotNull(valueSerializer);
            this.keySerializerConfigSnapshot = (TypeSerializerConfigSnapshot)Preconditions.checkNotNull((Object)keySerializerConfigSnapshot);
            this.valueSerializerConfigSnapshot = (TypeSerializerConfigSnapshot)Preconditions.checkNotNull((Object)valueSerializerConfigSnapshot);
        }

        public String getName() {
            return this.name;
        }

        void setName(String name) {
            this.name = name;
        }

        public OperatorStateHandle.Mode getAssignmentMode() {
            return this.assignmentMode;
        }

        void setAssignmentMode(OperatorStateHandle.Mode mode) {
            this.assignmentMode = mode;
        }

        public TypeSerializer<K> getKeySerializer() {
            return this.keySerializer;
        }

        void setKeySerializer(TypeSerializer<K> serializer) {
            this.keySerializer = serializer;
        }

        public TypeSerializer<V> getValueSerializer() {
            return this.valueSerializer;
        }

        void setValueSerializer(TypeSerializer<V> serializer) {
            this.valueSerializer = serializer;
        }

        public TypeSerializerConfigSnapshot getKeySerializerConfigSnapshot() {
            return this.keySerializerConfigSnapshot;
        }

        void setKeySerializerConfigSnapshot(TypeSerializerConfigSnapshot configSnapshot) {
            this.keySerializerConfigSnapshot = configSnapshot;
        }

        public TypeSerializerConfigSnapshot getValueSerializerConfigSnapshot() {
            return this.valueSerializerConfigSnapshot;
        }

        void setValueSerializerConfigSnapshot(TypeSerializerConfigSnapshot configSnapshot) {
            this.valueSerializerConfigSnapshot = configSnapshot;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Snapshot)) {
                return false;
            }
            Snapshot snapshot = (Snapshot)obj;
            return this.name.equals(snapshot.getName()) && this.assignmentMode.ordinal() == snapshot.getAssignmentMode().ordinal() && Objects.equals(this.keySerializer, snapshot.getKeySerializer()) && Objects.equals(this.valueSerializer, snapshot.getValueSerializer()) && this.keySerializerConfigSnapshot.equals((Object)snapshot.getKeySerializerConfigSnapshot()) && this.valueSerializerConfigSnapshot.equals((Object)snapshot.getValueSerializerConfigSnapshot());
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.assignmentMode.hashCode();
            result = 31 * result + (this.keySerializer != null ? this.keySerializer.hashCode() : 0);
            result = 31 * result + (this.valueSerializer != null ? this.valueSerializer.hashCode() : 0);
            result = 31 * result + this.keySerializerConfigSnapshot.hashCode();
            result = 31 * result + this.valueSerializerConfigSnapshot.hashCode();
            return result;
        }
    }
}

