/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.metrics;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import org.apache.flink.runtime.jobmaster.JobManagerGateway;
import org.apache.flink.runtime.rest.handler.legacy.AbstractJsonRequestHandler;
import org.apache.flink.runtime.rest.handler.legacy.JsonFactory;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;

public abstract class AbstractMetricsHandler
extends AbstractJsonRequestHandler {
    public static final String PARAMETER_METRICS = "get";
    private final MetricFetcher fetcher;

    public AbstractMetricsHandler(Executor executor, MetricFetcher fetcher) {
        super(executor);
        this.fetcher = (MetricFetcher)Preconditions.checkNotNull((Object)fetcher);
    }

    @Override
    public CompletableFuture<String> handleJsonRequest(Map<String, String> pathParams, Map<String, String> queryParams, JobManagerGateway jobManagerGateway) {
        return CompletableFuture.supplyAsync(() -> {
            this.fetcher.update();
            String requestedMetricsList = (String)queryParams.get(PARAMETER_METRICS);
            try {
                return requestedMetricsList != null ? this.getMetricsValues(pathParams, requestedMetricsList) : this.getAvailableMetricsList(pathParams);
            }
            catch (IOException e) {
                throw new CompletionException(new FlinkException("Could not retrieve metrics.", (Throwable)e));
            }
        }, this.executor);
    }

    protected abstract Map<String, String> getMapFor(Map<String, String> var1, MetricStore var2);

    private String getMetricsValues(Map<String, String> pathParams, String requestedMetricsList) throws IOException {
        if (requestedMetricsList.isEmpty()) {
            return "";
        }
        Map<String, String> metrics = this.getMapFor(pathParams, this.fetcher.getMetricStore());
        if (metrics == null) {
            return "";
        }
        String[] requestedMetrics = requestedMetricsList.split(",");
        StringWriter writer = new StringWriter();
        JsonGenerator gen = JsonFactory.JACKSON_FACTORY.createGenerator((Writer)writer);
        gen.writeStartArray();
        for (String requestedMetric : requestedMetrics) {
            String metricValue = metrics.get(requestedMetric);
            if (metricValue == null) continue;
            gen.writeStartObject();
            gen.writeStringField("id", requestedMetric);
            gen.writeStringField("value", metricValue.toString());
            gen.writeEndObject();
        }
        gen.writeEndArray();
        gen.close();
        return writer.toString();
    }

    private String getAvailableMetricsList(Map<String, String> pathParams) throws IOException {
        Map<String, String> metrics = this.getMapFor(pathParams, this.fetcher.getMetricStore());
        if (metrics == null) {
            return "";
        }
        StringWriter writer = new StringWriter();
        JsonGenerator gen = JsonFactory.JACKSON_FACTORY.createGenerator((Writer)writer);
        gen.writeStartArray();
        for (String m : metrics.keySet()) {
            gen.writeStartObject();
            gen.writeStringField("id", m);
            gen.writeEndObject();
        }
        gen.writeEndArray();
        gen.close();
        return writer.toString();
    }
}

