/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.messages.FlinkJobNotFoundException;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobIDPathParameter;
import org.apache.flink.runtime.rest.messages.JobMessageParameters;
import org.apache.flink.runtime.rest.messages.job.JobExecutionResultHeaders;
import org.apache.flink.runtime.rest.messages.job.JobExecutionResultResponseBody;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.ExceptionUtils;

public class JobExecutionResultHandler
extends AbstractRestHandler<RestfulGateway, EmptyRequestBody, JobExecutionResultResponseBody, JobMessageParameters> {
    public JobExecutionResultHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders) {
        super(localRestAddress, leaderRetriever, timeout, responseHeaders, JobExecutionResultHeaders.getInstance());
    }

    @Override
    protected CompletableFuture<JobExecutionResultResponseBody> handleRequest(@Nonnull HandlerRequest<EmptyRequestBody, JobMessageParameters> request, @Nonnull RestfulGateway gateway) throws RestHandlerException {
        JobID jobId = (JobID)request.getPathParameter(JobIDPathParameter.class);
        CompletableFuture<JobStatus> jobStatusFuture = gateway.requestJobStatus(jobId, this.timeout);
        return ((CompletableFuture)jobStatusFuture.thenCompose(jobStatus -> {
            if (jobStatus.isGloballyTerminalState()) {
                return gateway.requestJobResult(jobId, this.timeout).thenApply(JobExecutionResultResponseBody::created);
            }
            return CompletableFuture.completedFuture(JobExecutionResultResponseBody.inProgress());
        })).exceptionally(throwable -> {
            throw JobExecutionResultHandler.propagateException(throwable);
        });
    }

    private static CompletionException propagateException(Throwable throwable) {
        Throwable cause = ExceptionUtils.stripCompletionException((Throwable)throwable);
        if (cause instanceof FlinkJobNotFoundException) {
            throw new CompletionException((Throwable)((Object)new RestHandlerException(throwable.getMessage(), HttpResponseStatus.NOT_FOUND, throwable)));
        }
        throw new CompletionException(throwable);
    }
}

