/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest;

import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.net.SSLEngineFactory;
import org.apache.flink.runtime.net.SSLUtils;
import org.apache.flink.util.ConfigurationException;
import org.apache.flink.util.Preconditions;

public final class RestClientConfiguration {
    @Nullable
    private final SSLEngineFactory sslEngineFactory;
    private final long connectionTimeout;
    private final long idlenessTimeout;
    private final int maxContentLength;

    private RestClientConfiguration(@Nullable SSLEngineFactory sslEngineFactory, long connectionTimeout, long idlenessTimeout, int maxContentLength) {
        Preconditions.checkArgument((maxContentLength > 0 ? 1 : 0) != 0, (String)"maxContentLength must be positive, was: %d", (Object[])new Object[]{maxContentLength});
        this.sslEngineFactory = sslEngineFactory;
        this.connectionTimeout = connectionTimeout;
        this.idlenessTimeout = idlenessTimeout;
        this.maxContentLength = maxContentLength;
    }

    @Nullable
    public SSLEngineFactory getSslEngineFactory() {
        return this.sslEngineFactory;
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public long getIdlenessTimeout() {
        return this.idlenessTimeout;
    }

    public int getMaxContentLength() {
        return this.maxContentLength;
    }

    public static RestClientConfiguration fromConfiguration(Configuration config) throws ConfigurationException {
        SSLEngineFactory sslEngineFactory;
        Preconditions.checkNotNull((Object)config);
        boolean enableSSL = config.getBoolean(SecurityOptions.SSL_ENABLED);
        if (enableSSL) {
            try {
                sslEngineFactory = SSLUtils.createClientSSLEngineFactory(config);
            }
            catch (Exception e) {
                throw new ConfigurationException("Failed to initialize SSLContext for the web frontend", (Throwable)e);
            }
        } else {
            sslEngineFactory = null;
        }
        long connectionTimeout = config.getLong(RestOptions.CONNECTION_TIMEOUT);
        long idlenessTimeout = config.getLong(RestOptions.IDLENESS_TIMEOUT);
        int maxContentLength = config.getInteger(RestOptions.CLIENT_MAX_CONTENT_LENGTH);
        return new RestClientConfiguration(sslEngineFactory, connectionTimeout, idlenessTimeout, maxContentLength);
    }
}

