/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.overlays;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.clusterframework.ContainerSpecification;
import org.apache.flink.runtime.clusterframework.overlays.AbstractContainerOverlay;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkDistributionOverlay
extends AbstractContainerOverlay {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkDistributionOverlay.class);
    static final Path TARGET_ROOT = new Path("flink");
    final File flinkBinPath;
    final File flinkConfPath;
    final File flinkLibPath;

    public FlinkDistributionOverlay(File flinkBinPath, File flinkConfPath, File flinkLibPath) {
        this.flinkBinPath = (File)Preconditions.checkNotNull((Object)flinkBinPath);
        this.flinkConfPath = (File)Preconditions.checkNotNull((Object)flinkConfPath);
        this.flinkLibPath = (File)Preconditions.checkNotNull((Object)flinkLibPath);
    }

    @Override
    public void configure(ContainerSpecification container) throws IOException {
        container.getEnvironmentVariables().put("FLINK_HOME", TARGET_ROOT.toString());
        this.addPathRecursively(this.flinkBinPath, TARGET_ROOT, container);
        this.addPathRecursively(this.flinkConfPath, TARGET_ROOT, container);
        this.addPathRecursively(this.flinkLibPath, TARGET_ROOT, container);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        File flinkBinPath;
        File flinkConfPath;
        File flinkLibPath;

        public Builder fromEnvironment(Configuration globalConfiguration) {
            Map<String, String> env = System.getenv();
            if (!env.containsKey("FLINK_BIN_DIR")) {
                throw new IllegalStateException(String.format("the %s environment variable must be set", "FLINK_BIN_DIR"));
            }
            this.flinkBinPath = new File(System.getenv("FLINK_BIN_DIR"));
            if (!env.containsKey("FLINK_CONF_DIR")) {
                throw new IllegalStateException(String.format("the %s environment variable must be set", "FLINK_CONF_DIR"));
            }
            this.flinkConfPath = new File(System.getenv("FLINK_CONF_DIR"));
            if (!env.containsKey("FLINK_LIB_DIR")) {
                throw new IllegalStateException(String.format("the %s environment variable must be set", "FLINK_LIB_DIR"));
            }
            this.flinkLibPath = new File(System.getenv("FLINK_LIB_DIR"));
            return this;
        }

        public FlinkDistributionOverlay build() {
            return new FlinkDistributionOverlay(this.flinkBinPath, this.flinkConfPath, this.flinkLibPath);
        }
    }
}

