/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor.slot;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotPayload;

class TestingTaskSlotPayload
implements TaskSlotPayload {
    private final JobID jobId;
    private final ExecutionAttemptID executionAttemptID;
    private final AllocationID allocationID;
    private final CompletableFuture<Void> terminationFuture = new CompletableFuture();
    private final OneShotLatch failLatch = new OneShotLatch();

    TestingTaskSlotPayload() {
        this(new JobID(), new ExecutionAttemptID(), new AllocationID());
    }

    TestingTaskSlotPayload(JobID jobId, ExecutionAttemptID executionAttemptID, AllocationID allocationID) {
        this.jobId = jobId;
        this.executionAttemptID = executionAttemptID;
        this.allocationID = allocationID;
    }

    public JobID getJobID() {
        return this.jobId;
    }

    public ExecutionAttemptID getExecutionId() {
        return this.executionAttemptID;
    }

    public AllocationID getAllocationId() {
        return this.allocationID;
    }

    public CompletableFuture<Void> getTerminationFuture() {
        return this.terminationFuture;
    }

    public void failExternally(Throwable cause) {
        this.failLatch.trigger();
    }

    void waitForFailure() throws InterruptedException {
        this.failLatch.await();
    }

    TestingTaskSlotPayload terminate() {
        this.terminationFuture.complete(null);
        return this;
    }
}

