/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.filesystem.FileStateHandle;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FileStateHandleTest {
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();

    @Test
    public void testDisposeDeletesFile() throws Exception {
        File file = this.tempFolder.newFile();
        FileStateHandleTest.writeTestData(file);
        Assert.assertTrue((boolean)file.exists());
        FileStateHandle handle = new FileStateHandle(Path.fromLocalFile((File)file), file.length());
        handle.discardState();
        Assert.assertFalse((boolean)file.exists());
    }

    @Test
    public void testDisposeDoesNotDeleteParentDirectory() throws Exception {
        File parentDir = this.tempFolder.newFolder();
        Assert.assertTrue((boolean)parentDir.exists());
        File file = new File(parentDir, "test");
        FileStateHandleTest.writeTestData(file);
        Assert.assertTrue((boolean)file.exists());
        FileStateHandle handle = new FileStateHandle(Path.fromLocalFile((File)file), file.length());
        handle.discardState();
        Assert.assertFalse((boolean)file.exists());
        Assert.assertTrue((boolean)parentDir.exists());
    }

    private static void writeTestData(File file) throws IOException {
        Random rnd = new Random();
        byte[] data = new byte[rnd.nextInt(1024) + 1];
        rnd.nextBytes(data);
        try (FileOutputStream out = new FileOutputStream(file);){
            ((OutputStream)out).write(data);
        }
    }
}

