/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.runtime.scheduler.adaptive.Created;
import org.apache.flink.runtime.scheduler.adaptive.CreatedTest;
import org.apache.flink.runtime.scheduler.adaptive.WaitingForResources;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class StateTest
extends TestLogger {
    @Test
    public void testEmptyAs() throws Exception {
        try (CreatedTest.MockCreatedContext ctx = new CreatedTest.MockCreatedContext();){
            Created state = new Created((Created.Context)ctx, this.log);
            Assert.assertThat((Object)state.as(WaitingForResources.class), (Matcher)CoreMatchers.is(Optional.empty()));
        }
    }

    @Test
    public void testCast() throws Exception {
        try (CreatedTest.MockCreatedContext ctx = new CreatedTest.MockCreatedContext();){
            Created state = new Created((Created.Context)ctx, this.log);
            Assert.assertThat((Object)state.as(Created.class), (Matcher)CoreMatchers.is(Optional.of(state)));
        }
    }

    @Test
    public void testTryRunStateMismatch() throws Exception {
        try (CreatedTest.MockCreatedContext ctx = new CreatedTest.MockCreatedContext();){
            Created state = new Created((Created.Context)ctx, this.log);
            state.tryRun(WaitingForResources.class, waiting -> Assert.fail((String)"Unexpected execution"), "test");
        }
    }

    @Test
    public void testTryRun() throws Exception {
        try (CreatedTest.MockCreatedContext ctx = new CreatedTest.MockCreatedContext();){
            Created state = new Created((Created.Context)ctx, this.log);
            AtomicBoolean called = new AtomicBoolean(false);
            state.tryRun(Created.class, created -> called.set(true), "test");
            Assert.assertThat((Object)called.get(), (Matcher)CoreMatchers.is((Object)true));
        }
    }

    @Test
    public void testTryCallStateMismatch() throws Exception {
        try (CreatedTest.MockCreatedContext ctx = new CreatedTest.MockCreatedContext();){
            Created state = new Created((Created.Context)ctx, this.log);
            Optional result = state.tryCall(WaitingForResources.class, Waiting -> {
                Assert.fail((String)"Unexpected execution");
                return "nope";
            }, "test");
            Assert.assertThat((Object)result, (Matcher)CoreMatchers.is(Optional.empty()));
        }
    }

    @Test
    public void testTryCall() throws Exception {
        try (CreatedTest.MockCreatedContext ctx = new CreatedTest.MockCreatedContext();){
            Created state = new Created((Created.Context)ctx, this.log);
            Optional result = state.tryCall(Created.class, created -> "yes", "test");
            Assert.assertThat((Object)result, (Matcher)CoreMatchers.is(Optional.of("yes")));
        }
    }
}

