/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.Collections;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.scheduler.SchedulerBase;
import org.apache.flink.runtime.scheduler.VertexParallelismInformation;
import org.apache.flink.runtime.scheduler.VertexParallelismStore;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SchedulerBaseComputeVertexParallelismTest
extends TestLogger {
    @Parameterized.Parameter(value=0)
    public int parallelism;
    @Parameterized.Parameter(value=1)
    public int maxParallelism;
    @Parameterized.Parameter(value=2)
    public int expectedMaxParallelism;
    @Parameterized.Parameter(value=3)
    public int maxToScaleTo;
    @Parameterized.Parameter(value=4)
    public boolean expectedCanRescaleTo;

    @Parameterized.Parameters(name="parallelism = {0}, maxParallelism = {1}, expected max = {2}, rescale to = {3}, can rescale = {4}")
    public static Object[][] data() {
        return new Object[][]{{1, -1, 128, 3, true}, {171, -1, 256, 42, true}, {172, -1, 512, 174, true}, {32768, -1, 32768, 32768, true}, {4, 32768, 32768, 3, false}, {4, 7, 7, 32768, false}};
    }

    @Test
    public void testMaxParallelismDefaulting() {
        JobVertex jobVertex = ExecutionGraphTestUtils.createNoOpVertex("test", this.parallelism, this.maxParallelism);
        VertexParallelismStore store = SchedulerBase.computeVertexParallelismStore(Collections.singleton(jobVertex));
        VertexParallelismInformation info = store.getParallelismInfo(jobVertex.getID());
        Assert.assertEquals((String)"constant parallelism", (long)this.parallelism, (long)info.getParallelism());
        Assert.assertEquals((String)"expected max", (long)this.expectedMaxParallelism, (long)info.getMaxParallelism());
        Assert.assertEquals((String)"can rescale max", (Object)this.expectedCanRescaleTo, (Object)info.canRescaleMaxParallelism(this.maxToScaleTo));
    }
}

