/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.ArrayList;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.resourcemanager.registration.TaskExecutorConnection;
import org.apache.flink.runtime.resourcemanager.slotmanager.FineGrainedTaskManagerRegistration;
import org.apache.flink.runtime.resourcemanager.slotmanager.FineGrainedTaskManagerSlot;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotState;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskManagerSlotInformation;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.TestingTaskExecutorGatewayBuilder;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class FineGrainedTaskManagerRegistrationTest
extends TestLogger {
    private static final TaskExecutorConnection TASK_EXECUTOR_CONNECTION = new TaskExecutorConnection(ResourceID.generate(), (TaskExecutorGateway)new TestingTaskExecutorGatewayBuilder().createTestingTaskExecutorGateway());

    @Test
    public void testFreeSlot() {
        ResourceProfile totalResource = ResourceProfile.fromResources((double)10.0, (int)1000);
        FineGrainedTaskManagerRegistration taskManager = new FineGrainedTaskManagerRegistration(TASK_EXECUTOR_CONNECTION, totalResource, totalResource);
        AllocationID allocationId = new AllocationID();
        JobID jobId = new JobID();
        FineGrainedTaskManagerSlot slot = new FineGrainedTaskManagerSlot(allocationId, jobId, ResourceProfile.fromResources((double)2.0, (int)100), TASK_EXECUTOR_CONNECTION, SlotState.ALLOCATED);
        taskManager.notifyAllocation(allocationId, slot);
        taskManager.freeSlot(allocationId);
        Assert.assertThat((Object)taskManager.getAvailableResource(), (Matcher)Is.is((Object)totalResource));
        Assert.assertThat((Object)taskManager.getIdleSince(), (Matcher)Matchers.not((Object)Long.MAX_VALUE));
        Assert.assertTrue((boolean)taskManager.getAllocatedSlots().isEmpty());
    }

    @Test
    public void testNotifyAllocation() {
        ResourceProfile totalResource = ResourceProfile.fromResources((double)10.0, (int)1000);
        FineGrainedTaskManagerRegistration taskManager = new FineGrainedTaskManagerRegistration(TASK_EXECUTOR_CONNECTION, totalResource, totalResource);
        AllocationID allocationId = new AllocationID();
        JobID jobId = new JobID();
        FineGrainedTaskManagerSlot slot = new FineGrainedTaskManagerSlot(allocationId, jobId, ResourceProfile.fromResources((double)2.0, (int)100), TASK_EXECUTOR_CONNECTION, SlotState.ALLOCATED);
        taskManager.notifyAllocation(allocationId, slot);
        Assert.assertThat((Object)taskManager.getAvailableResource(), (Matcher)Is.is((Object)ResourceProfile.fromResources((double)8.0, (int)900)));
        Assert.assertThat((Object)taskManager.getIdleSince(), (Matcher)Is.is((Object)Long.MAX_VALUE));
        Assert.assertTrue((boolean)taskManager.getAllocatedSlots().containsKey(allocationId));
    }

    @Test
    public void testNotifyAllocationComplete() {
        ResourceProfile totalResource = ResourceProfile.fromResources((double)10.0, (int)1000);
        FineGrainedTaskManagerRegistration taskManager = new FineGrainedTaskManagerRegistration(TASK_EXECUTOR_CONNECTION, totalResource, totalResource);
        AllocationID allocationId = new AllocationID();
        JobID jobId = new JobID();
        FineGrainedTaskManagerSlot slot = new FineGrainedTaskManagerSlot(allocationId, jobId, ResourceProfile.fromResources((double)2.0, (int)100), TASK_EXECUTOR_CONNECTION, SlotState.PENDING);
        taskManager.notifyAllocation(allocationId, slot);
        Assert.assertThat((Object)taskManager.getAvailableResource(), (Matcher)Is.is((Object)ResourceProfile.fromResources((double)8.0, (int)900)));
        Assert.assertThat((Object)taskManager.getIdleSince(), (Matcher)Is.is((Object)Long.MAX_VALUE));
        Assert.assertTrue((boolean)taskManager.getAllocatedSlots().containsKey(allocationId));
        taskManager.notifyAllocationComplete(allocationId);
        Assert.assertThat((Object)taskManager.getAvailableResource(), (Matcher)Is.is((Object)ResourceProfile.fromResources((double)8.0, (int)900)));
        Assert.assertThat((Object)taskManager.getIdleSince(), (Matcher)Is.is((Object)Long.MAX_VALUE));
        Assert.assertTrue((boolean)taskManager.getAllocatedSlots().containsKey(allocationId));
        Assert.assertThat((Object)((TaskManagerSlotInformation)taskManager.getAllocatedSlots().get(allocationId)).getState(), (Matcher)Is.is((Object)SlotState.ALLOCATED));
    }

    @Test
    public void testNotifyAllocationWithoutEnoughResource() {
        ResourceProfile totalResource = ResourceProfile.fromResources((double)1.0, (int)100);
        FineGrainedTaskManagerRegistration taskManager = new FineGrainedTaskManagerRegistration(TASK_EXECUTOR_CONNECTION, totalResource, totalResource);
        AllocationID allocationId = new AllocationID();
        JobID jobId = new JobID();
        FineGrainedTaskManagerSlot slot1 = new FineGrainedTaskManagerSlot(allocationId, jobId, ResourceProfile.fromResources((double)2.0, (int)100), TASK_EXECUTOR_CONNECTION, SlotState.PENDING);
        FineGrainedTaskManagerSlot slot2 = new FineGrainedTaskManagerSlot(allocationId, jobId, ResourceProfile.fromResources((double)2.0, (int)100), TASK_EXECUTOR_CONNECTION, SlotState.ALLOCATED);
        ArrayList<RuntimeException> exceptions = new ArrayList<RuntimeException>();
        try {
            taskManager.notifyAllocation(allocationId, slot1);
        }
        catch (IllegalStateException e) {
            exceptions.add(e);
        }
        try {
            taskManager.notifyAllocation(allocationId, slot2);
        }
        catch (IllegalArgumentException e) {
            exceptions.add(e);
        }
        Assert.assertThat((Object)exceptions.size(), (Matcher)Is.is((Object)2));
    }
}

