/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.executiongraph.TestingComponentMainThreadExecutor;
import org.apache.flink.runtime.executiongraph.utils.SimpleAckingTaskManagerGateway;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolBuilder;
import org.apache.flink.runtime.jobmaster.slotpool.TestingSlotPoolImpl;
import org.apache.flink.runtime.resourcemanager.utils.TestingResourceManagerGateway;
import org.apache.flink.runtime.taskexecutor.slot.SlotOffer;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class SlotPoolInteractionsTest
extends TestLogger {
    private static final Time fastTimeout = Time.milliseconds((long)1L);
    @ClassRule
    public static final TestingComponentMainThreadExecutor.Resource EXECUTOR_RESOURCE = new TestingComponentMainThreadExecutor.Resource(10L);
    private final TestingComponentMainThreadExecutor testMainThreadExecutor = EXECUTOR_RESOURCE.getComponentMainThreadTestExecutor();

    @Test
    public void testSlotAllocationNoResourceManager() throws Exception {
        try (TestingSlotPoolImpl pool = this.createAndSetUpSlotPoolWithoutResourceManager();){
            CompletableFuture future = (CompletableFuture)this.testMainThreadExecutor.execute(() -> SlotPoolInteractionsTest.lambda$testSlotAllocationNoResourceManager$0((SlotPool)pool));
            try {
                future.get();
                Assert.fail((String)"We expected an ExecutionException.");
            }
            catch (ExecutionException e) {
                Assert.assertTrue((boolean)(ExceptionUtils.stripExecutionException((Throwable)e) instanceof TimeoutException));
            }
        }
    }

    @Test
    public void testCancelSlotAllocationWithoutResourceManager() throws Exception {
        try (TestingSlotPoolImpl pool = this.createAndSetUpSlotPoolWithoutResourceManager();){
            CompletableFuture timeoutFuture = new CompletableFuture();
            pool.setTimeoutPendingSlotRequestConsumer(timeoutFuture::complete);
            CompletableFuture future = (CompletableFuture)this.testMainThreadExecutor.execute(() -> pool.requestNewAllocatedSlot(new SlotRequestId(), ResourceProfile.UNKNOWN, fastTimeout));
            try {
                future.get();
                Assert.fail((String)"We expected a TimeoutException.");
            }
            catch (ExecutionException e) {
                Assert.assertTrue((boolean)(ExceptionUtils.stripExecutionException((Throwable)e) instanceof TimeoutException));
            }
            timeoutFuture.get();
            Assert.assertEquals((long)0L, (long)pool.getNumberOfWaitingForResourceRequests());
        }
    }

    @Test
    public void testSlotAllocationTimeout() throws Exception {
        try (TestingSlotPoolImpl pool = this.createAndSetUpSlotPool();){
            CompletableFuture slotRequestTimeoutFuture = new CompletableFuture();
            pool.setTimeoutPendingSlotRequestConsumer(slotRequestTimeoutFuture::complete);
            CompletableFuture future = (CompletableFuture)this.testMainThreadExecutor.execute(() -> pool.requestNewAllocatedSlot(new SlotRequestId(), ResourceProfile.UNKNOWN, fastTimeout));
            try {
                future.get();
                Assert.fail((String)"We expected a TimeoutException.");
            }
            catch (ExecutionException e) {
                Assert.assertTrue((boolean)(ExceptionUtils.stripExecutionException((Throwable)e) instanceof TimeoutException));
            }
            slotRequestTimeoutFuture.get();
            Assert.assertEquals((long)0L, (long)pool.getNumberOfPendingRequests());
        }
    }

    @Test
    public void testExtraSlotsAreKept() throws Exception {
        CompletableFuture allocationIdFuture = new CompletableFuture();
        TestingResourceManagerGateway resourceManagerGateway = new TestingResourceManagerGateway();
        resourceManagerGateway.setRequestSlotConsumer(slotRequest -> allocationIdFuture.complete(slotRequest.getAllocationId()));
        try (TestingSlotPoolImpl pool = new SlotPoolBuilder(this.testMainThreadExecutor.getMainThreadExecutor()).setResourceManagerGateway(resourceManagerGateway).build();){
            CompletableFuture slotRequestTimeoutFuture = new CompletableFuture();
            pool.setTimeoutPendingSlotRequestConsumer(slotRequestTimeoutFuture::complete);
            CompletableFuture future = (CompletableFuture)this.testMainThreadExecutor.execute(() -> pool.requestNewAllocatedSlot(new SlotRequestId(), ResourceProfile.UNKNOWN, fastTimeout));
            try {
                future.get();
                Assert.fail((String)"We expected a TimeoutException.");
            }
            catch (ExecutionException e) {
                Assert.assertTrue((boolean)(ExceptionUtils.stripExecutionException((Throwable)e) instanceof TimeoutException));
            }
            slotRequestTimeoutFuture.get();
            Assert.assertEquals((long)0L, (long)pool.getNumberOfPendingRequests());
            AllocationID allocationId = (AllocationID)allocationIdFuture.get();
            SlotOffer slotOffer = new SlotOffer(allocationId, 0, ResourceProfile.ANY);
            LocalTaskManagerLocation taskManagerLocation = new LocalTaskManagerLocation();
            SimpleAckingTaskManagerGateway taskManagerGateway = new SimpleAckingTaskManagerGateway();
            this.testMainThreadExecutor.execute(() -> pool.registerTaskManager(taskManagerLocation.getResourceID()));
            Assert.assertTrue((boolean)((Boolean)this.testMainThreadExecutor.execute(() -> pool.offerSlot(taskManagerLocation, taskManagerGateway, slotOffer))));
            Assert.assertTrue((boolean)pool.containsAvailableSlot(allocationId));
        }
    }

    private TestingSlotPoolImpl createAndSetUpSlotPool() throws Exception {
        return new SlotPoolBuilder(this.testMainThreadExecutor.getMainThreadExecutor()).build();
    }

    private TestingSlotPoolImpl createAndSetUpSlotPoolWithoutResourceManager() throws Exception {
        return new SlotPoolBuilder(this.testMainThreadExecutor.getMainThreadExecutor()).setResourceManagerGateway(null).build();
    }

    private static /* synthetic */ CompletableFuture lambda$testSlotAllocationNoResourceManager$0(SlotPool pool) throws Throwable {
        return pool.requestNewAllocatedSlot(new SlotRequestId(), ResourceProfile.UNKNOWN, fastTimeout);
    }
}

