/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import org.apache.flink.runtime.io.network.netty.ByteBufUtils;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.Unpooled;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class ByteBufUtilsTest
extends TestLogger {
    private static final byte ACCUMULATION_BYTE = 125;
    private static final byte NON_ACCUMULATION_BYTE = 35;

    @Test
    public void testAccumulateWithoutCopy() {
        int sourceLength = 128;
        int sourceReaderIndex = 32;
        int expectedAccumulationSize = 16;
        ByteBuf src = this.createSourceBuffer(sourceLength, sourceReaderIndex, expectedAccumulationSize);
        ByteBuf target = Unpooled.buffer((int)expectedAccumulationSize);
        ByteBuf accumulated = ByteBufUtils.accumulate((ByteBuf)target, (ByteBuf)src, (int)expectedAccumulationSize, (int)target.readableBytes());
        Assert.assertSame((Object)src, (Object)accumulated);
        Assert.assertEquals((long)sourceReaderIndex, (long)src.readerIndex());
        this.verifyBufferContent(src, sourceReaderIndex, expectedAccumulationSize);
    }

    @Test
    public void testAccumulateWithCopy() {
        int sourceLength = 128;
        int firstSourceReaderIndex = 32;
        int secondSourceReaderIndex = 0;
        int expectedAccumulationSize = 128;
        int firstAccumulationSize = sourceLength - firstSourceReaderIndex;
        int secondAccumulationSize = expectedAccumulationSize - firstAccumulationSize;
        ByteBuf firstSource = this.createSourceBuffer(sourceLength, firstSourceReaderIndex, firstAccumulationSize);
        ByteBuf secondSource = this.createSourceBuffer(sourceLength, secondSourceReaderIndex, secondAccumulationSize);
        ByteBuf target = Unpooled.buffer((int)expectedAccumulationSize);
        ByteBuf accumulated = ByteBufUtils.accumulate((ByteBuf)target, (ByteBuf)firstSource, (int)expectedAccumulationSize, (int)target.readableBytes());
        Assert.assertNull((Object)accumulated);
        Assert.assertEquals((long)sourceLength, (long)firstSource.readerIndex());
        Assert.assertEquals((long)firstAccumulationSize, (long)target.readableBytes());
        accumulated = ByteBufUtils.accumulate((ByteBuf)target, (ByteBuf)secondSource, (int)expectedAccumulationSize, (int)target.readableBytes());
        Assert.assertSame((Object)target, (Object)accumulated);
        Assert.assertEquals((long)(secondSourceReaderIndex + secondAccumulationSize), (long)secondSource.readerIndex());
        Assert.assertEquals((long)expectedAccumulationSize, (long)target.readableBytes());
        this.verifyBufferContent(accumulated, 0, expectedAccumulationSize);
    }

    private ByteBuf createSourceBuffer(int size, int readerIndex, int accumulationSize) {
        int i;
        ByteBuf buf = Unpooled.buffer((int)size);
        for (i = 0; i < readerIndex; ++i) {
            buf.writeByte(35);
        }
        for (i = readerIndex; i < readerIndex + accumulationSize; ++i) {
            buf.writeByte(125);
        }
        for (i = readerIndex + accumulationSize; i < size; ++i) {
            buf.writeByte(35);
        }
        buf.readerIndex(readerIndex);
        return buf;
    }

    private void verifyBufferContent(ByteBuf buf, int start, int length) {
        for (int i = 0; i < length; ++i) {
            byte b = buf.getByte(start + i);
            Assert.assertEquals((String)String.format("The byte at position %d is not right.", start + i), (long)125L, (long)b);
        }
    }
}

