/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.heartbeat;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.heartbeat.HeartbeatListener;

final class TestingHeartbeatListener<I, O>
implements HeartbeatListener<I, O> {
    private final Consumer<ResourceID> notifyHeartbeatTimeoutConsumer;
    private final BiConsumer<ResourceID, I> reportPayloadConsumer;
    private final Function<ResourceID, O> retrievePayloadFunction;

    TestingHeartbeatListener(Consumer<ResourceID> notifyHeartbeatTimeoutConsumer, BiConsumer<ResourceID, I> reportPayloadConsumer, Function<ResourceID, O> retrievePayloadFunction) {
        this.notifyHeartbeatTimeoutConsumer = notifyHeartbeatTimeoutConsumer;
        this.reportPayloadConsumer = reportPayloadConsumer;
        this.retrievePayloadFunction = retrievePayloadFunction;
    }

    public void notifyHeartbeatTimeout(ResourceID resourceID) {
        this.notifyHeartbeatTimeoutConsumer.accept(resourceID);
    }

    public void reportPayload(ResourceID resourceID, I payload) {
        this.reportPayloadConsumer.accept(resourceID, payload);
    }

    public O retrievePayload(ResourceID resourceID) {
        return this.retrievePayloadFunction.apply(resourceID);
    }
}

