/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.overlays;

import java.security.PrivilegedAction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.clusterframework.ContainerSpecification;
import org.apache.flink.runtime.clusterframework.overlays.ContainerOverlayTestBase;
import org.apache.flink.runtime.clusterframework.overlays.HadoopUserOverlay;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Test;

public class HadoopUserOverlayTest
extends ContainerOverlayTestBase {
    @Test
    public void testConfigure() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"test");
        HadoopUserOverlay overlay = new HadoopUserOverlay(ugi);
        ContainerSpecification spec = new ContainerSpecification();
        overlay.configure(spec);
        Assert.assertEquals((Object)ugi.getUserName(), spec.getEnvironmentVariables().get("HADOOP_USER_NAME"));
    }

    @Test
    public void testNoConf() throws Exception {
        HadoopUserOverlay overlay = new HadoopUserOverlay(null);
        ContainerSpecification containerSpecification = new ContainerSpecification();
        overlay.configure(containerSpecification);
    }

    @Test
    public void testBuilderFromEnvironment() throws Exception {
        final Configuration conf = new Configuration();
        final UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"test");
        ugi.doAs((PrivilegedAction)new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    HadoopUserOverlay.Builder builder = HadoopUserOverlay.newBuilder().fromEnvironment(conf);
                    Assert.assertEquals((Object)ugi, (Object)builder.ugi);
                    return null;
                }
                catch (Exception ex) {
                    throw new AssertionError((Object)ex);
                }
            }
        });
    }
}

