/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.runtime.checkpoint.CheckpointStatsCounts;
import org.apache.flink.runtime.checkpoint.CheckpointStatsHistory;
import org.apache.flink.runtime.checkpoint.CheckpointStatsSnapshot;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStats;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStatsSummary;
import org.apache.flink.runtime.checkpoint.RestoredCheckpointStats;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class CheckpointStatsSnapshotTest {
    @Test
    public void testIsJavaSerializable() throws Exception {
        CheckpointStatsCounts counts = new CheckpointStatsCounts();
        counts.incrementInProgressCheckpoints();
        counts.incrementInProgressCheckpoints();
        counts.incrementInProgressCheckpoints();
        counts.incrementCompletedCheckpoints();
        counts.incrementFailedCheckpoints();
        counts.incrementRestoredCheckpoints();
        CompletedCheckpointStatsSummary summary = new CompletedCheckpointStatsSummary();
        summary.updateSummary(this.createCompletedCheckpointsStats(12398L, 9919L));
        summary.updateSummary(this.createCompletedCheckpointsStats(2221L, 3333L));
        CheckpointStatsHistory history = new CheckpointStatsHistory(1);
        RestoredCheckpointStats restored = new RestoredCheckpointStats(1L, CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION), 99119L, null);
        CheckpointStatsSnapshot snapshot = new CheckpointStatsSnapshot(counts, summary, history, restored);
        CheckpointStatsSnapshot copy = (CheckpointStatsSnapshot)CommonTestUtils.createCopySerializable((Serializable)snapshot);
        Assert.assertEquals((long)counts.getNumberOfCompletedCheckpoints(), (long)copy.getCounts().getNumberOfCompletedCheckpoints());
        Assert.assertEquals((long)counts.getNumberOfFailedCheckpoints(), (long)copy.getCounts().getNumberOfFailedCheckpoints());
        Assert.assertEquals((long)counts.getNumberOfInProgressCheckpoints(), (long)copy.getCounts().getNumberOfInProgressCheckpoints());
        Assert.assertEquals((long)counts.getNumberOfRestoredCheckpoints(), (long)copy.getCounts().getNumberOfRestoredCheckpoints());
        Assert.assertEquals((long)counts.getTotalNumberOfCheckpoints(), (long)copy.getCounts().getTotalNumberOfCheckpoints());
        Assert.assertEquals((long)summary.getStateSizeStats().getSum(), (long)copy.getSummaryStats().getStateSizeStats().getSum());
        Assert.assertEquals((long)summary.getEndToEndDurationStats().getSum(), (long)copy.getSummaryStats().getEndToEndDurationStats().getSum());
        Assert.assertEquals((long)restored.getCheckpointId(), (long)copy.getLatestRestoredCheckpoint().getCheckpointId());
    }

    private CompletedCheckpointStats createCompletedCheckpointsStats(long stateSize, long endToEndDuration) {
        CompletedCheckpointStats completed = (CompletedCheckpointStats)Mockito.mock(CompletedCheckpointStats.class);
        Mockito.when((Object)completed.getStateSize()).thenReturn((Object)stateSize);
        Mockito.when((Object)completed.getEndToEndDuration()).thenReturn((Object)endToEndDuration);
        return completed;
    }
}

