/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointFailureManager;
import org.apache.flink.runtime.checkpoint.CheckpointFailureReason;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class CheckpointFailureManagerTest
extends TestLogger {
    @Test
    public void testIgnoresPastCheckpoints() {
        TestFailJobCallback callback = new TestFailJobCallback();
        CheckpointFailureManager failureManager = new CheckpointFailureManager(2, (CheckpointFailureManager.FailJobCallback)callback);
        failureManager.handleJobLevelCheckpointException(new CheckpointException(CheckpointFailureReason.CHECKPOINT_EXPIRED), 1L);
        failureManager.handleJobLevelCheckpointException(new CheckpointException(CheckpointFailureReason.CHECKPOINT_EXPIRED), 2L);
        failureManager.handleCheckpointSuccess(2L);
        failureManager.handleJobLevelCheckpointException(new CheckpointException(CheckpointFailureReason.CHECKPOINT_EXPIRED), 1L);
        failureManager.handleJobLevelCheckpointException(new CheckpointException(CheckpointFailureReason.CHECKPOINT_EXPIRED), 3L);
        failureManager.handleJobLevelCheckpointException(new CheckpointException(CheckpointFailureReason.CHECKPOINT_EXPIRED), 4L);
        Assert.assertEquals((long)0L, (long)callback.getInvokeCounter());
    }

    @Test
    public void testContinuousFailure() {
        TestFailJobCallback callback = new TestFailJobCallback();
        CheckpointFailureManager failureManager = new CheckpointFailureManager(2, (CheckpointFailureManager.FailJobCallback)callback);
        failureManager.handleJobLevelCheckpointException(new CheckpointException(CheckpointFailureReason.CHECKPOINT_DECLINED), 1L);
        failureManager.handleJobLevelCheckpointException(new CheckpointException(CheckpointFailureReason.CHECKPOINT_DECLINED), 2L);
        failureManager.handleJobLevelCheckpointException(new CheckpointException(CheckpointFailureReason.JOB_FAILOVER_REGION), 3L);
        failureManager.handleJobLevelCheckpointException(new CheckpointException(CheckpointFailureReason.CHECKPOINT_DECLINED), 4L);
        Assert.assertEquals((long)1L, (long)callback.getInvokeCounter());
    }

    @Test
    public void testBreakContinuousFailure() {
        TestFailJobCallback callback = new TestFailJobCallback();
        CheckpointFailureManager failureManager = new CheckpointFailureManager(2, (CheckpointFailureManager.FailJobCallback)callback);
        failureManager.handleJobLevelCheckpointException(new CheckpointException(CheckpointFailureReason.EXCEPTION), 1L);
        failureManager.handleJobLevelCheckpointException(new CheckpointException(CheckpointFailureReason.CHECKPOINT_DECLINED), 2L);
        failureManager.handleJobLevelCheckpointException(new CheckpointException(CheckpointFailureReason.JOB_FAILOVER_REGION), 3L);
        failureManager.handleCheckpointSuccess(4L);
        failureManager.handleJobLevelCheckpointException(new CheckpointException(CheckpointFailureReason.CHECKPOINT_EXPIRED), 5L);
        Assert.assertEquals((long)0L, (long)callback.getInvokeCounter());
    }

    @Test
    public void testTotalCountValue() {
        TestFailJobCallback callback = new TestFailJobCallback();
        CheckpointFailureManager failureManager = new CheckpointFailureManager(0, (CheckpointFailureManager.FailJobCallback)callback);
        for (CheckpointFailureReason reason : CheckpointFailureReason.values()) {
            failureManager.handleJobLevelCheckpointException(new CheckpointException(reason), -1L);
        }
        Assert.assertEquals((long)3L, (long)callback.getInvokeCounter());
    }

    @Test
    public void testIgnoreOneCheckpointRepeatedlyCountMultiTimes() {
        TestFailJobCallback callback = new TestFailJobCallback();
        CheckpointFailureManager failureManager = new CheckpointFailureManager(2, (CheckpointFailureManager.FailJobCallback)callback);
        failureManager.handleJobLevelCheckpointException(new CheckpointException(CheckpointFailureReason.CHECKPOINT_DECLINED), 1L);
        failureManager.handleJobLevelCheckpointException(new CheckpointException(CheckpointFailureReason.CHECKPOINT_DECLINED), 2L);
        failureManager.handleJobLevelCheckpointException(new CheckpointException(CheckpointFailureReason.JOB_FAILOVER_REGION), 3L);
        failureManager.handleJobLevelCheckpointException(new CheckpointException(CheckpointFailureReason.CHECKPOINT_DECLINED), 2L);
        Assert.assertEquals((long)0L, (long)callback.getInvokeCounter());
    }

    private static class TestFailJobCallback
    implements CheckpointFailureManager.FailJobCallback {
        private int invokeCounter = 0;

        private TestFailJobCallback() {
        }

        public void failJob(Throwable cause) {
            ++this.invokeCounter;
        }

        public void failJobDueToTaskFailure(Throwable cause, ExecutionAttemptID executionAttemptID) {
            ++this.invokeCounter;
        }

        public int getInvokeCounter() {
            return this.invokeCounter;
        }
    }
}

