/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.util.Arrays;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessSpec;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessUtils;
import org.apache.flink.runtime.taskexecutor.TaskManagerRunner;
import org.apache.flink.util.Preconditions;

public class BashJavaUtils {
    private static final String EXECUTION_PREFIX = "BASH_JAVA_UTILS_EXEC_RESULT:";

    public static void main(String[] args) throws Exception {
        Preconditions.checkArgument((args.length > 0 ? 1 : 0) != 0, (Object)"Command not specified.");
        switch (Command.valueOf(args[0])) {
            case GET_TM_RESOURCE_DYNAMIC_CONFIGS: {
                BashJavaUtils.getTmResourceDynamicConfigs(args);
                break;
            }
            case GET_TM_RESOURCE_JVM_PARAMS: {
                BashJavaUtils.getTmResourceJvmParams(args);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected, something is wrong.");
            }
        }
    }

    private static void getTmResourceDynamicConfigs(String[] args) throws Exception {
        Configuration configuration = BashJavaUtils.getConfigurationForStandaloneTaskManagers(args);
        TaskExecutorProcessSpec taskExecutorProcessSpec = TaskExecutorProcessUtils.processSpecFromConfig(configuration);
        System.out.println(EXECUTION_PREFIX + TaskExecutorProcessUtils.generateDynamicConfigsStr(taskExecutorProcessSpec));
    }

    private static void getTmResourceJvmParams(String[] args) throws Exception {
        Configuration configuration = BashJavaUtils.getConfigurationForStandaloneTaskManagers(args);
        TaskExecutorProcessSpec taskExecutorProcessSpec = TaskExecutorProcessUtils.processSpecFromConfig(configuration);
        System.out.println(EXECUTION_PREFIX + TaskExecutorProcessUtils.generateJvmParametersStr(taskExecutorProcessSpec));
    }

    private static Configuration getConfigurationForStandaloneTaskManagers(String[] args) throws Exception {
        Configuration configuration = TaskManagerRunner.loadConfiguration(Arrays.copyOfRange(args, 1, args.length));
        return TaskExecutorProcessUtils.getConfigurationMapLegacyTaskManagerHeapSizeToConfigOption(configuration, (ConfigOption<MemorySize>)TaskManagerOptions.TOTAL_FLINK_MEMORY);
    }

    public static enum Command {
        GET_TM_RESOURCE_DYNAMIC_CONFIGS,
        GET_TM_RESOURCE_JVM_PARAMS;

    }
}

