/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.resourcemanager.JobLeaderIdService;
import org.apache.flink.runtime.resourcemanager.ResourceManagerRuntimeServicesConfiguration;
import org.apache.flink.runtime.resourcemanager.slotmanager.AnyMatchingSlotMatchingStrategy;
import org.apache.flink.runtime.resourcemanager.slotmanager.LeastUtilizationSlotMatchingStrategy;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManagerConfiguration;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManagerImpl;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotMatchingStrategy;
import org.apache.flink.util.Preconditions;

public class ResourceManagerRuntimeServices {
    private final SlotManager slotManager;
    private final JobLeaderIdService jobLeaderIdService;

    public ResourceManagerRuntimeServices(SlotManager slotManager, JobLeaderIdService jobLeaderIdService) {
        this.slotManager = (SlotManager)Preconditions.checkNotNull((Object)slotManager);
        this.jobLeaderIdService = (JobLeaderIdService)Preconditions.checkNotNull((Object)jobLeaderIdService);
    }

    public SlotManager getSlotManager() {
        return this.slotManager;
    }

    public JobLeaderIdService getJobLeaderIdService() {
        return this.jobLeaderIdService;
    }

    public static ResourceManagerRuntimeServices fromConfiguration(ResourceManagerRuntimeServicesConfiguration configuration, HighAvailabilityServices highAvailabilityServices, ScheduledExecutor scheduledExecutor) throws Exception {
        SlotManager slotManager = ResourceManagerRuntimeServices.createSlotManager(configuration, scheduledExecutor);
        JobLeaderIdService jobLeaderIdService = new JobLeaderIdService(highAvailabilityServices, scheduledExecutor, configuration.getJobTimeout());
        return new ResourceManagerRuntimeServices(slotManager, jobLeaderIdService);
    }

    private static SlotManager createSlotManager(ResourceManagerRuntimeServicesConfiguration configuration, ScheduledExecutor scheduledExecutor) {
        SlotManagerConfiguration slotManagerConfiguration = configuration.getSlotManagerConfiguration();
        Enum slotMatchingStrategy = slotManagerConfiguration.evenlySpreadOutSlots() ? LeastUtilizationSlotMatchingStrategy.INSTANCE : AnyMatchingSlotMatchingStrategy.INSTANCE;
        return new SlotManagerImpl((SlotMatchingStrategy)((Object)slotMatchingStrategy), scheduledExecutor, slotManagerConfiguration.getTaskManagerRequestTimeout(), slotManagerConfiguration.getSlotRequestTimeout(), slotManagerConfiguration.getTaskManagerTimeout(), slotManagerConfiguration.isWaitResultConsumedBeforeRelease());
    }
}

