/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.scheduler;

import javax.annotation.Nullable;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.instance.SlotSharingGroupId;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationConstraint;
import org.apache.flink.util.Preconditions;

public class ScheduledUnit {
    @Nullable
    private final Execution vertexExecution;
    private final JobVertexID jobVertexId;
    @Nullable
    private final SlotSharingGroupId slotSharingGroupId;
    @Nullable
    private final CoLocationConstraint coLocationConstraint;

    public ScheduledUnit(Execution task) {
        this((Execution)Preconditions.checkNotNull((Object)task), task.getVertex().getJobvertexId(), null, null);
    }

    public ScheduledUnit(Execution task, @Nullable SlotSharingGroupId slotSharingGroupId) {
        this((Execution)Preconditions.checkNotNull((Object)task), task.getVertex().getJobvertexId(), slotSharingGroupId, null);
    }

    public ScheduledUnit(Execution task, @Nullable SlotSharingGroupId slotSharingGroupId, @Nullable CoLocationConstraint coLocationConstraint) {
        this((Execution)Preconditions.checkNotNull((Object)task), task.getVertex().getJobvertexId(), slotSharingGroupId, coLocationConstraint);
    }

    public ScheduledUnit(JobVertexID jobVertexId, @Nullable SlotSharingGroupId slotSharingGroupId, @Nullable CoLocationConstraint coLocationConstraint) {
        this(null, jobVertexId, slotSharingGroupId, coLocationConstraint);
    }

    public ScheduledUnit(@Nullable Execution task, JobVertexID jobVertexId, @Nullable SlotSharingGroupId slotSharingGroupId, @Nullable CoLocationConstraint coLocationConstraint) {
        this.vertexExecution = task;
        this.jobVertexId = (JobVertexID)Preconditions.checkNotNull((Object)jobVertexId);
        this.slotSharingGroupId = slotSharingGroupId;
        this.coLocationConstraint = coLocationConstraint;
    }

    public JobVertexID getJobVertexId() {
        return this.jobVertexId;
    }

    @Nullable
    public Execution getTaskToExecute() {
        return this.vertexExecution;
    }

    @Nullable
    public SlotSharingGroupId getSlotSharingGroupId() {
        return this.slotSharingGroupId;
    }

    @Nullable
    public CoLocationConstraint getCoLocationConstraint() {
        return this.coLocationConstraint;
    }

    public String toString() {
        return "{task=" + this.vertexExecution.getVertexWithAttempt() + ", sharingUnit=" + (Object)((Object)this.slotSharingGroupId) + ", locationConstraint=" + this.coLocationConstraint + '}';
    }
}

