/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.io.Serializable;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.shuffle.PartitionDescriptor;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.runtime.state.KeyGroupRangeAssignment;
import org.apache.flink.util.Preconditions;

public class ResultPartitionDeploymentDescriptor
implements Serializable {
    private static final long serialVersionUID = 6343547936086963705L;
    private final PartitionDescriptor partitionDescriptor;
    private final ShuffleDescriptor shuffleDescriptor;
    private final int maxParallelism;
    private final boolean sendScheduleOrUpdateConsumersMessage;

    public ResultPartitionDeploymentDescriptor(PartitionDescriptor partitionDescriptor, ShuffleDescriptor shuffleDescriptor, int maxParallelism, boolean sendScheduleOrUpdateConsumersMessage) {
        this.partitionDescriptor = (PartitionDescriptor)Preconditions.checkNotNull((Object)partitionDescriptor);
        this.shuffleDescriptor = (ShuffleDescriptor)Preconditions.checkNotNull((Object)shuffleDescriptor);
        KeyGroupRangeAssignment.checkParallelismPreconditions(maxParallelism);
        this.maxParallelism = maxParallelism;
        this.sendScheduleOrUpdateConsumersMessage = sendScheduleOrUpdateConsumersMessage;
    }

    public IntermediateDataSetID getResultId() {
        return this.partitionDescriptor.getResultId();
    }

    public IntermediateResultPartitionID getPartitionId() {
        return this.partitionDescriptor.getPartitionId();
    }

    public ResultPartitionType getPartitionType() {
        return this.partitionDescriptor.getPartitionType();
    }

    public int getTotalNumberOfPartitions() {
        return this.partitionDescriptor.getTotalNumberOfPartitions();
    }

    public int getNumberOfSubpartitions() {
        return this.partitionDescriptor.getNumberOfSubpartitions();
    }

    public int getMaxParallelism() {
        return this.maxParallelism;
    }

    public ShuffleDescriptor getShuffleDescriptor() {
        return this.shuffleDescriptor;
    }

    public boolean sendScheduleOrUpdateConsumersMessage() {
        return this.sendScheduleOrUpdateConsumersMessage;
    }

    public String toString() {
        return String.format("ResultPartitionDeploymentDescriptor [PartitionDescriptor: %s, ShuffleDescriptor: %s]", this.partitionDescriptor, this.shuffleDescriptor);
    }
}

