/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework;

import java.io.Serializable;
import org.apache.flink.api.common.resources.CPUResource;
import org.apache.flink.configuration.MemorySize;

public class TaskExecutorProcessSpec
implements Serializable {
    private final CPUResource cpuCores;
    private final MemorySize frameworkHeapSize;
    private final MemorySize frameworkOffHeapMemorySize;
    private final MemorySize taskHeapSize;
    private final MemorySize taskOffHeapSize;
    private final MemorySize networkMemSize;
    private final MemorySize managedMemorySize;
    private final MemorySize jvmMetaspaceSize;
    private final MemorySize jvmOverheadSize;

    public TaskExecutorProcessSpec(CPUResource cpuCores, MemorySize frameworkHeapSize, MemorySize frameworkOffHeapSize, MemorySize taskHeapSize, MemorySize taskOffHeapSize, MemorySize networkMemSize, MemorySize managedMemorySize, MemorySize jvmMetaspaceSize, MemorySize jvmOverheadSize) {
        this.cpuCores = cpuCores;
        this.frameworkHeapSize = frameworkHeapSize;
        this.frameworkOffHeapMemorySize = frameworkOffHeapSize;
        this.taskHeapSize = taskHeapSize;
        this.taskOffHeapSize = taskOffHeapSize;
        this.networkMemSize = networkMemSize;
        this.managedMemorySize = managedMemorySize;
        this.jvmMetaspaceSize = jvmMetaspaceSize;
        this.jvmOverheadSize = jvmOverheadSize;
    }

    public CPUResource getCpuCores() {
        return this.cpuCores;
    }

    public MemorySize getFrameworkHeapSize() {
        return this.frameworkHeapSize;
    }

    public MemorySize getFrameworkOffHeapMemorySize() {
        return this.frameworkOffHeapMemorySize;
    }

    public MemorySize getTaskHeapSize() {
        return this.taskHeapSize;
    }

    public MemorySize getTaskOffHeapSize() {
        return this.taskOffHeapSize;
    }

    public MemorySize getNetworkMemSize() {
        return this.networkMemSize;
    }

    public MemorySize getManagedMemorySize() {
        return this.managedMemorySize;
    }

    public MemorySize getJvmMetaspaceSize() {
        return this.jvmMetaspaceSize;
    }

    public MemorySize getJvmOverheadSize() {
        return this.jvmOverheadSize;
    }

    public MemorySize getTotalFlinkMemorySize() {
        return this.frameworkHeapSize.add(this.frameworkOffHeapMemorySize).add(this.taskHeapSize).add(this.taskOffHeapSize).add(this.networkMemSize).add(this.getManagedMemorySize());
    }

    public MemorySize getTotalProcessMemorySize() {
        return this.getTotalFlinkMemorySize().add(this.jvmMetaspaceSize).add(this.jvmOverheadSize);
    }

    public MemorySize getJvmHeapMemorySize() {
        return this.frameworkHeapSize.add(this.taskHeapSize);
    }

    public MemorySize getJvmDirectMemorySize() {
        return this.frameworkOffHeapMemorySize.add(this.taskOffHeapSize).add(this.networkMemSize);
    }

    public String toString() {
        return "TaskExecutorProcessSpec {cpuCores=" + this.cpuCores.getValue().doubleValue() + ", frameworkHeapSize=" + this.frameworkHeapSize.toHumanReadableString() + ", frameworkOffHeapSize=" + this.frameworkOffHeapMemorySize.toHumanReadableString() + ", taskHeapSize=" + this.taskHeapSize.toHumanReadableString() + ", taskOffHeapSize=" + this.taskOffHeapSize.toHumanReadableString() + ", networkMemSize=" + this.networkMemSize.toHumanReadableString() + ", managedMemorySize=" + this.managedMemorySize.toHumanReadableString() + ", jvmMetaspaceSize=" + this.jvmMetaspaceSize.toHumanReadableString() + ", jvmOverheadSize=" + this.jvmOverheadSize.toHumanReadableString() + "}";
    }
}

