/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.shaded.guava33.com.google.common.collect.Lists;
import org.apache.flink.util.OutputTag;

public class SideOutputTransformation<T>
extends Transformation<T> {
    private final Transformation<?> input;
    private final OutputTag<T> tag;

    public SideOutputTransformation(Transformation<?> input, OutputTag<T> tag) {
        super("SideOutput", tag.getTypeInfo(), Objects.requireNonNull(input).getParallelism());
        this.input = input;
        this.tag = Objects.requireNonNull(tag);
    }

    public OutputTag<T> getOutputTag() {
        return this.tag;
    }

    protected List<Transformation<?>> getTransitivePredecessorsInternal() {
        ArrayList result = Lists.newArrayList();
        result.add(this);
        result.addAll(this.input.getTransitivePredecessors());
        return result;
    }

    public List<Transformation<?>> getInputs() {
        return Collections.singletonList(this.input);
    }
}

