/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.connector.sink2;

import java.io.Serializable;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.connector.sink2.Committer;
import org.apache.flink.api.connector.sink2.CommitterInitContext;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.streaming.api.connector.sink2.CommittableMessage;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.transformations.GlobalCommitterTransform;
import org.apache.flink.util.function.SerializableFunction;
import org.apache.flink.util.function.SerializableSupplier;

@Experimental
public class StandardSinkTopologies {
    public static final String GLOBAL_COMMITTER_TRANSFORMATION_NAME = "Global Committer";

    private StandardSinkTopologies() {
    }

    public static <CommT> void addGlobalCommitter(DataStream<CommittableMessage<CommT>> committables, SerializableFunction<CommitterInitContext, Committer<CommT>> committerFactory, SerializableSupplier<SimpleVersionedSerializer<CommT>> committableSerializer) {
        committables.getExecutionEnvironment().addOperator(new GlobalCommitterTransform<CommT>(committables, committerFactory, committableSerializer));
    }

    public static <CommT> void addGlobalCommitter(DataStream<CommittableMessage<CommT>> committables, SerializableSupplier<Committer<CommT>> committerFactory, SerializableSupplier<SimpleVersionedSerializer<CommT>> committableSerializer) {
        committables.getExecutionEnvironment().addOperator(new GlobalCommitterTransform<CommT>(committables, (SerializableFunction & Serializable)ctx -> (Committer)committerFactory.get(), committableSerializer));
    }
}

