/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive.allocator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.scheduler.adaptive.allocator.JobInformation;
import org.apache.flink.runtime.scheduler.adaptive.allocator.SlotSharingResolver;
import org.apache.flink.runtime.scheduler.adaptive.allocator.SlotSharingSlotAllocator;
import org.apache.flink.runtime.scheduler.adaptive.allocator.VertexParallelism;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;

@Internal
public enum DefaultSlotSharingResolver implements SlotSharingResolver
{
    INSTANCE;


    @Override
    public Collection<SlotSharingSlotAllocator.ExecutionSlotSharingGroup> getExecutionSlotSharingGroups(JobInformation jobInformation, VertexParallelism vertexParallelism) {
        ArrayList<SlotSharingSlotAllocator.ExecutionSlotSharingGroup> allGroups = new ArrayList<SlotSharingSlotAllocator.ExecutionSlotSharingGroup>();
        for (SlotSharingGroup slotSharingGroup : jobInformation.getSlotSharingGroups()) {
            allGroups.addAll(DefaultSlotSharingResolver.createExecutionSlotSharingGroups(vertexParallelism, slotSharingGroup));
        }
        return allGroups;
    }

    static List<SlotSharingSlotAllocator.ExecutionSlotSharingGroup> createExecutionSlotSharingGroups(VertexParallelism vertexParallelism, SlotSharingGroup slotSharingGroup) {
        HashMap sharedSlotToVertexAssignment = new HashMap();
        slotSharingGroup.getJobVertexIds().forEach(jobVertexId -> {
            int parallelism = vertexParallelism.getParallelism((JobVertexID)jobVertexId);
            for (int subtaskIdx = 0; subtaskIdx < parallelism; ++subtaskIdx) {
                sharedSlotToVertexAssignment.computeIfAbsent(subtaskIdx, ignored -> new HashSet()).add(new ExecutionVertexID((JobVertexID)jobVertexId, subtaskIdx));
            }
        });
        return sharedSlotToVertexAssignment.values().stream().map(executionVertexIDs -> new SlotSharingSlotAllocator.ExecutionSlotSharingGroup(slotSharingGroup, (Set<ExecutionVertexID>)executionVertexIDs)).collect(Collectors.toList());
    }
}

