/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph.topology;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.flink.runtime.executiongraph.failover.LogicalPipelinedRegionComputeUtil;
import org.apache.flink.runtime.jobgraph.IntermediateDataSet;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.topology.DefaultLogicalPipelinedRegion;
import org.apache.flink.runtime.jobgraph.topology.DefaultLogicalResult;
import org.apache.flink.runtime.jobgraph.topology.DefaultLogicalVertex;
import org.apache.flink.runtime.jobgraph.topology.LogicalTopology;
import org.apache.flink.runtime.jobgraph.topology.LogicalVertex;
import org.apache.flink.util.Preconditions;

public class DefaultLogicalTopology
implements LogicalTopology {
    private final List<DefaultLogicalVertex> verticesSorted;
    private final Map<JobVertexID, DefaultLogicalVertex> idToVertexMap;
    private final Map<IntermediateDataSetID, DefaultLogicalResult> idToResultMap;

    private DefaultLogicalTopology(List<JobVertex> jobVertices) {
        Preconditions.checkNotNull(jobVertices);
        this.verticesSorted = new ArrayList<DefaultLogicalVertex>(jobVertices.size());
        this.idToVertexMap = new HashMap<JobVertexID, DefaultLogicalVertex>();
        this.idToResultMap = new HashMap<IntermediateDataSetID, DefaultLogicalResult>();
        this.buildVerticesAndResults(jobVertices);
    }

    public static DefaultLogicalTopology fromJobGraph(JobGraph jobGraph) {
        Preconditions.checkNotNull((Object)jobGraph);
        return DefaultLogicalTopology.fromTopologicallySortedJobVertices(jobGraph.getVerticesSortedTopologicallyFromSources());
    }

    public static DefaultLogicalTopology fromTopologicallySortedJobVertices(List<JobVertex> jobVertices) {
        return new DefaultLogicalTopology(jobVertices);
    }

    private void buildVerticesAndResults(Iterable<JobVertex> topologicallySortedJobVertices) {
        Function<JobVertexID, DefaultLogicalVertex> vertexRetriever = this::getVertex;
        Function<IntermediateDataSetID, DefaultLogicalResult> resultRetriever = this::getResult;
        for (JobVertex jobVertex : topologicallySortedJobVertices) {
            DefaultLogicalVertex logicalVertex = new DefaultLogicalVertex(jobVertex, resultRetriever);
            this.verticesSorted.add(logicalVertex);
            this.idToVertexMap.put(logicalVertex.getId(), logicalVertex);
            for (IntermediateDataSet intermediateDataSet : jobVertex.getProducedDataSets()) {
                DefaultLogicalResult logicalResult = new DefaultLogicalResult(intermediateDataSet, vertexRetriever);
                this.idToResultMap.put(logicalResult.getId(), logicalResult);
            }
        }
    }

    @Override
    public Iterable<DefaultLogicalVertex> getVertices() {
        return this.verticesSorted;
    }

    public DefaultLogicalVertex getVertex(JobVertexID vertexId) {
        return Optional.ofNullable(this.idToVertexMap.get(vertexId)).orElseThrow(() -> new IllegalArgumentException("can not find vertex: " + String.valueOf(vertexId)));
    }

    private DefaultLogicalResult getResult(IntermediateDataSetID resultId) {
        return Optional.ofNullable(this.idToResultMap.get(resultId)).orElseThrow(() -> new IllegalArgumentException("can not find result: " + String.valueOf(resultId)));
    }

    @Override
    public Iterable<DefaultLogicalPipelinedRegion> getAllPipelinedRegions() {
        Set<Set<LogicalVertex>> regionsRaw = LogicalPipelinedRegionComputeUtil.computePipelinedRegions(this.verticesSorted);
        HashSet<DefaultLogicalPipelinedRegion> regions = new HashSet<DefaultLogicalPipelinedRegion>();
        for (Set<LogicalVertex> regionVertices : regionsRaw) {
            regions.add(new DefaultLogicalPipelinedRegion(regionVertices));
        }
        return regions;
    }
}

