/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage;

import java.util.LinkedList;
import javax.annotation.Nullable;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.partition.BufferWithSubpartition;
import org.apache.flink.runtime.io.network.partition.SortBuffer;
import org.apache.flink.util.Preconditions;

public class TieredStorageSortBuffer
extends SortBuffer {
    private final boolean isPartialRecordAllowed;
    private boolean isLastBufferPartialRecord;

    public TieredStorageSortBuffer(LinkedList<MemorySegment> freeSegments, BufferRecycler bufferRecycler, int numSubpartitions, int bufferSize, int numGuaranteedBuffers, boolean isPartialRecordAllowed) {
        super(freeSegments, bufferRecycler, numSubpartitions, bufferSize, numGuaranteedBuffers, null);
        this.isPartialRecordAllowed = isPartialRecordAllowed;
        this.isLastBufferPartialRecord = false;
    }

    @Override
    public BufferWithSubpartition getNextBuffer(@Nullable MemorySegment transitBuffer) {
        Preconditions.checkState((boolean)this.isFinished, (Object)"Sort buffer is not ready to be read.");
        Preconditions.checkState((!this.isReleased ? 1 : 0) != 0, (Object)"Sort buffer is already released.");
        if (!this.hasRemaining()) {
            this.freeSegments.add(transitBuffer);
            return null;
        }
        int numBytesRead = 0;
        Buffer.DataType bufferDataType = Buffer.DataType.DATA_BUFFER;
        int currentReadingSubpartitionId = this.subpartitionReadOrder[this.readOrderIndex];
        do {
            int toReadBufferIndex = this.getSegmentIndexFromPointer(this.readIndexEntryAddress);
            int toReadOffsetInBuffer = this.getSegmentOffsetFromPointer(this.readIndexEntryAddress);
            MemorySegment toReadBuffer = (MemorySegment)this.segments.get(toReadBufferIndex);
            long lengthAndDataType = toReadBuffer.getLong(toReadOffsetInBuffer);
            int recordLength = this.getSegmentIndexFromPointer(lengthAndDataType);
            Buffer.DataType dataType = Buffer.DataType.values()[this.getSegmentOffsetFromPointer(lengthAndDataType)];
            if (dataType.isEvent() && numBytesRead > 0) break;
            bufferDataType = dataType;
            long nextReadIndexEntryAddress = toReadBuffer.getLong(toReadOffsetInBuffer + 8);
            toReadOffsetInBuffer += 16;
            if (bufferDataType.isEvent()) {
                this.freeSegments.add(transitBuffer);
                transitBuffer = MemorySegmentFactory.allocateUnpooledSegment((int)recordLength);
            }
            if (!this.isPartialRecordAllowed && !this.isLastBufferPartialRecord && numBytesRead > 0 && numBytesRead + recordLength > transitBuffer.size()) break;
            numBytesRead += this.copyRecordOrEvent(transitBuffer, numBytesRead, toReadBufferIndex, toReadOffsetInBuffer, recordLength);
            if (this.recordRemainingBytes == 0) {
                if (this.readIndexEntryAddress == this.lastIndexEntryAddresses[currentReadingSubpartitionId]) {
                    this.isLastBufferPartialRecord = false;
                    this.updateReadSubpartitionAndIndexEntryAddress();
                    break;
                }
                this.readIndexEntryAddress = nextReadIndexEntryAddress;
                if (!this.isLastBufferPartialRecord) continue;
                this.isLastBufferPartialRecord = false;
                break;
            }
            this.isLastBufferPartialRecord = true;
        } while (numBytesRead < transitBuffer.size() && bufferDataType.isBuffer());
        if (!this.isPartialRecordAllowed && !this.isLastBufferPartialRecord && bufferDataType == Buffer.DataType.DATA_BUFFER) {
            bufferDataType = Buffer.DataType.DATA_BUFFER_WITH_CLEAR_END;
        }
        this.numTotalBytesRead += (long)numBytesRead;
        return new BufferWithSubpartition(new NetworkBuffer(transitBuffer, bufferDataType.isBuffer() ? this.bufferRecycler : FreeingBufferRecycler.INSTANCE, bufferDataType, numBytesRead), currentReadingSubpartitionId);
    }

    int getRecordRemainingBytes() {
        return this.recordRemainingBytes;
    }
}

