/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.json;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.rest.messages.json.JobIDDeserializer;
import org.apache.flink.runtime.rest.messages.json.SerializedThrowableDeserializer;
import org.apache.flink.runtime.rest.messages.json.SerializedValueDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonToken;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JavaType;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.type.TypeFactory;
import org.apache.flink.util.OptionalFailure;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedThrowable;
import org.apache.flink.util.SerializedValue;

public class JobResultDeserializer
extends StdDeserializer<JobResult> {
    private static final long serialVersionUID = 1L;
    private final JobIDDeserializer jobIdDeserializer = new JobIDDeserializer();
    private final SerializedThrowableDeserializer serializedThrowableDeserializer = new SerializedThrowableDeserializer();
    private final SerializedValueDeserializer serializedValueDeserializer;

    public JobResultDeserializer() {
        super(JobResult.class);
        JavaType objectSerializedValueType = TypeFactory.defaultInstance().constructType((TypeReference)new TypeReference<SerializedValue<Object>>(){});
        this.serializedValueDeserializer = new SerializedValueDeserializer(objectSerializedValueType);
    }

    public JobResult deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JobID jobId = null;
        ApplicationStatus applicationStatus = ApplicationStatus.UNKNOWN;
        long netRuntime = -1L;
        SerializedThrowable serializedThrowable = null;
        Map<String, SerializedValue<OptionalFailure<Object>>> accumulatorResults = null;
        while (true) {
            String fieldName;
            JsonToken jsonToken = p.nextToken();
            JobResultDeserializer.assertNotEndOfInput(p, jsonToken);
            if (jsonToken == JsonToken.END_OBJECT) break;
            switch (fieldName = p.getValueAsString()) {
                case "id": {
                    JobResultDeserializer.assertNextToken(p, JsonToken.VALUE_STRING);
                    jobId = this.jobIdDeserializer.deserialize(p, ctxt);
                    break;
                }
                case "application-status": {
                    JobResultDeserializer.assertNextToken(p, JsonToken.VALUE_STRING);
                    applicationStatus = ApplicationStatus.valueOf(p.getValueAsString().toUpperCase());
                    break;
                }
                case "net-runtime": {
                    JobResultDeserializer.assertNextToken(p, JsonToken.VALUE_NUMBER_INT);
                    netRuntime = p.getLongValue();
                    break;
                }
                case "accumulator-results": {
                    JobResultDeserializer.assertNextToken(p, JsonToken.START_OBJECT);
                    accumulatorResults = this.parseAccumulatorResults(p, ctxt);
                    break;
                }
                case "failure-cause": {
                    JobResultDeserializer.assertNextToken(p, JsonToken.START_OBJECT);
                    serializedThrowable = this.serializedThrowableDeserializer.deserialize(p, ctxt);
                    break;
                }
            }
        }
        try {
            return new JobResult.Builder().jobId(jobId).applicationStatus(applicationStatus).netRuntime(netRuntime).accumulatorResults(accumulatorResults).serializedThrowable(serializedThrowable).build();
        }
        catch (RuntimeException e) {
            throw new JsonMappingException(null, "Could not deserialize " + JobResult.class.getSimpleName(), (Throwable)e);
        }
    }

    private Map<String, SerializedValue<OptionalFailure<Object>>> parseAccumulatorResults(JsonParser p, DeserializationContext ctxt) throws IOException {
        HashMap<String, SerializedValue<OptionalFailure<Object>>> accumulatorResults = new HashMap<String, SerializedValue<OptionalFailure<Object>>>();
        while (true) {
            JsonToken jsonToken = p.nextToken();
            JobResultDeserializer.assertNotEndOfInput(p, jsonToken);
            if (jsonToken == JsonToken.END_OBJECT) break;
            String accumulatorName = p.getValueAsString();
            p.nextValue();
            accumulatorResults.put(accumulatorName, this.serializedValueDeserializer.deserialize(p, ctxt));
        }
        return accumulatorResults;
    }

    private static void assertNotEndOfInput(JsonParser p, @Nullable JsonToken jsonToken) {
        Preconditions.checkState((jsonToken != null ? 1 : 0) != 0, (String)"Unexpected end of input at %s", (Object[])new Object[]{p.getCurrentLocation()});
    }

    private static void assertNextToken(JsonParser p, JsonToken requiredJsonToken) throws IOException {
        JsonToken jsonToken = p.nextToken();
        if (jsonToken != requiredJsonToken) {
            throw new JsonMappingException((Closeable)p, String.format("Expected token %s (was %s)", requiredJsonToken, jsonToken));
        }
    }
}

