/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.runtime.io.network.partition.PartitionTracker;
import org.apache.flink.runtime.io.network.partition.PartitionTrackerEntry;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.taskexecutor.partition.PartitionTable;
import org.apache.flink.util.Preconditions;

public abstract class AbstractPartitionTracker<K, M>
implements PartitionTracker<K, M> {
    protected final PartitionTable<K> partitionTable = new PartitionTable();
    protected final Map<ResultPartitionID, PartitionInfo<K, M>> partitionInfos = new HashMap<ResultPartitionID, PartitionInfo<K, M>>();

    void startTrackingPartition(K key, ResultPartitionID resultPartitionId, M metaInfo) {
        this.partitionInfos.put(resultPartitionId, new PartitionInfo<K, M>(key, metaInfo));
        this.partitionTable.startTrackingPartitions(key, Collections.singletonList(resultPartitionId));
    }

    @Override
    public Collection<PartitionTrackerEntry<K, M>> stopTrackingPartitionsFor(K key) {
        Preconditions.checkNotNull(key);
        Collection<ResultPartitionID> resultPartitionIds = this.partitionTable.stopTrackingPartitions(key);
        return this.stopTrackingPartitions(resultPartitionIds);
    }

    @Override
    public Collection<PartitionTrackerEntry<K, M>> stopTrackingPartitions(Collection<ResultPartitionID> resultPartitionIds) {
        Preconditions.checkNotNull(resultPartitionIds);
        return resultPartitionIds.stream().map(this::internalStopTrackingPartition).flatMap(AbstractPartitionTracker::asStream).collect(Collectors.toList());
    }

    @Override
    public boolean isTrackingPartitionsFor(K key) {
        Preconditions.checkNotNull(key);
        return this.partitionTable.hasTrackedPartitions(key);
    }

    @Override
    public boolean isPartitionTracked(ResultPartitionID resultPartitionID) {
        Preconditions.checkNotNull((Object)resultPartitionID);
        return this.partitionInfos.containsKey(resultPartitionID);
    }

    private Optional<PartitionTrackerEntry<K, M>> internalStopTrackingPartition(ResultPartitionID resultPartitionId) {
        Preconditions.checkNotNull((Object)resultPartitionId);
        PartitionInfo<K, M> partitionInfo = this.partitionInfos.remove(resultPartitionId);
        if (partitionInfo == null) {
            return Optional.empty();
        }
        this.partitionTable.stopTrackingPartitions(partitionInfo.getKey(), Collections.singletonList(resultPartitionId));
        return Optional.of(new PartitionTrackerEntry<Object, M>(resultPartitionId, ((PartitionInfo)partitionInfo).key, partitionInfo.getMetaInfo()));
    }

    private static <X> Stream<X> asStream(Optional<X> optional) {
        if (optional.isPresent()) {
            return Stream.of(optional.get());
        }
        return Stream.empty();
    }

    static class PartitionInfo<K, M> {
        private final K key;
        private final M metaInfo;

        PartitionInfo(K key, M metaInfo) {
            this.key = key;
            this.metaInfo = metaInfo;
        }

        K getKey() {
            return this.key;
        }

        M getMetaInfo() {
            return this.metaInfo;
        }
    }
}

