/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.filemerging;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.checkpoint.filemerging.FileMergingSnapshotManager;
import org.apache.flink.runtime.checkpoint.filemerging.FileMergingSnapshotManagerBase;
import org.apache.flink.runtime.checkpoint.filemerging.PhysicalFile;
import org.apache.flink.runtime.checkpoint.filemerging.PhysicalFilePool;
import org.apache.flink.runtime.state.CheckpointedStateScope;

public class WithinCheckpointFileMergingSnapshotManager
extends FileMergingSnapshotManagerBase {
    private final Map<Long, PhysicalFilePool> writablePhysicalFilePool = new HashMap<Long, PhysicalFilePool>();

    public WithinCheckpointFileMergingSnapshotManager(String id, long maxFileSize, PhysicalFilePool.Type filePoolType, float maxSpaceAmplification, Executor ioExecutor, MetricGroup metricGroup) {
        super(id, maxFileSize, filePoolType, maxSpaceAmplification, ioExecutor, metricGroup);
    }

    @Override
    public void notifyCheckpointComplete(FileMergingSnapshotManager.SubtaskKey subtaskKey, long checkpointId) throws Exception {
        super.notifyCheckpointComplete(subtaskKey, checkpointId);
        this.removeAndCloseFiles(subtaskKey, checkpointId);
    }

    @Override
    public void notifyCheckpointAborted(FileMergingSnapshotManager.SubtaskKey subtaskKey, long checkpointId) throws Exception {
        super.notifyCheckpointAborted(subtaskKey, checkpointId);
        this.removeAndCloseFiles(subtaskKey, checkpointId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAndCloseFiles(FileMergingSnapshotManager.SubtaskKey subtaskKey, long checkpointId) throws Exception {
        PhysicalFilePool filePool;
        Map<Long, PhysicalFilePool> map = this.writablePhysicalFilePool;
        synchronized (map) {
            filePool = this.writablePhysicalFilePool.get(checkpointId);
        }
        if (filePool != null) {
            filePool.close(subtaskKey);
            if (filePool.isEmpty()) {
                map = this.writablePhysicalFilePool;
                synchronized (map) {
                    this.writablePhysicalFilePool.remove(checkpointId);
                }
            }
        }
    }

    @Override
    @Nonnull
    protected PhysicalFile getOrCreatePhysicalFileForCheckpoint(FileMergingSnapshotManager.SubtaskKey subtaskKey, long checkpointId, CheckpointedStateScope scope) throws IOException {
        PhysicalFilePool filePool = this.getOrCreateFilePool(checkpointId);
        return filePool.pollFile(subtaskKey, scope);
    }

    @Override
    protected void returnPhysicalFileForNextReuse(FileMergingSnapshotManager.SubtaskKey subtaskKey, long checkpointId, PhysicalFile physicalFile) throws IOException {
        PhysicalFilePool physicalFilePool;
        FSDataOutputStream os;
        if (this.shouldSyncAfterClosingLogicalFile && (os = physicalFile.getOutputStream()) != null) {
            os.sync();
        }
        if (!(physicalFilePool = this.getOrCreateFilePool(checkpointId)).tryPutFile(subtaskKey, physicalFile)) {
            physicalFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void discardCheckpoint(long checkpointId) throws IOException {
        PhysicalFilePool filePool;
        Map<Long, PhysicalFilePool> map = this.writablePhysicalFilePool;
        synchronized (map) {
            filePool = this.writablePhysicalFilePool.get(checkpointId);
        }
        if (filePool != null) {
            filePool.close();
        }
        super.discardCheckpoint(checkpointId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PhysicalFilePool getOrCreateFilePool(long checkpointId) {
        Map<Long, PhysicalFilePool> map = this.writablePhysicalFilePool;
        synchronized (map) {
            PhysicalFilePool filePool = this.writablePhysicalFilePool.get(checkpointId);
            if (filePool == null) {
                filePool = this.createPhysicalPool();
                this.writablePhysicalFilePool.put(checkpointId, filePool);
            }
            return filePool;
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        for (PhysicalFilePool filePool : this.writablePhysicalFilePool.values()) {
            filePool.close();
        }
        this.writablePhysicalFilePool.clear();
    }
}

