/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.asyncprocessing;

import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.memory.MemoryUtils;
import sun.misc.Unsafe;

@Internal
@ThreadSafe
public abstract class ReferenceCounted<ReleaseHelper> {
    private static final Unsafe unsafe = MemoryUtils.UNSAFE;
    private static final long referenceOffset;
    private volatile int referenceCount;

    public ReferenceCounted(int initReference) {
        this.referenceCount = initReference;
    }

    public int retain() {
        return unsafe.getAndAddInt(this, referenceOffset, 1) + 1;
    }

    public int tryRetain() {
        int v;
        while ((v = unsafe.getIntVolatile(this, referenceOffset)) != 0 && !unsafe.compareAndSwapInt(this, referenceOffset, v, v + 1)) {
        }
        return v == 0 ? 0 : v + 1;
    }

    public int release() {
        return this.release(null);
    }

    public int release(@Nullable ReleaseHelper releaseHelper) {
        int r = unsafe.getAndAddInt(this, referenceOffset, -1) - 1;
        if (r == 0) {
            this.referenceCountReachedZero(releaseHelper);
        }
        return r;
    }

    public int getReferenceCount() {
        return this.referenceCount;
    }

    protected abstract void referenceCountReachedZero(@Nullable ReleaseHelper var1);

    static {
        try {
            referenceOffset = unsafe.objectFieldOffset(ReferenceCounted.class.getDeclaredField("referenceCount"));
        }
        catch (SecurityException e) {
            throw new Error("Could not get field 'referenceCount' offset in class 'ReferenceCounted' for unsafe operations, permission denied by security manager.", e);
        }
        catch (NoSuchFieldException e) {
            throw new Error("Could not get field 'referenceCount' offset in class 'ReferenceCounted' for unsafe operations", e);
        }
        catch (Throwable t) {
            throw new Error("Could not get field 'referenceCount' offset in class 'ReferenceCounted' for unsafe operations, unclassified error", t);
        }
    }
}

