/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util.bash;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.runtime.util.bash.FlinkConfigLoader;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={ParameterizedTestExtension.class})
public class FlinkConfigLoaderTest {
    @Parameter
    public boolean standardYaml;
    private static final String TEST_CONFIG_KEY = "test.key";
    private static final String TEST_CONFIG_VALUE = "test_value";
    @TempDir
    private Path confDir;

    @Parameters(name="standardYaml: {0}")
    public static Collection<Boolean> parameters() {
        return Arrays.asList(true, false);
    }

    @BeforeEach
    void setUp() throws IOException {
        File flinkConfFile = this.standardYaml ? TempDirUtils.newFile((Path)this.confDir.toAbsolutePath(), (String)"config.yaml") : TempDirUtils.newFile((Path)this.confDir.toAbsolutePath(), (String)"flink-conf.yaml");
        FileWriter fw = new FileWriter(flinkConfFile);
        fw.write("test.key: test_value\n");
        fw.close();
    }

    @AfterAll
    static void after() {
        GlobalConfiguration.setStandardYaml((boolean)true);
    }

    @TestTemplate
    void testLoadConfigurationConfigDirLongOpt() throws Exception {
        String[] args = new String[]{"--configDir", this.confDir.toFile().getAbsolutePath()};
        Configuration configuration = FlinkConfigLoader.loadConfiguration((String[])args);
        this.verifyConfiguration(configuration, TEST_CONFIG_KEY, TEST_CONFIG_VALUE);
    }

    @TestTemplate
    void testloadAndModifyConfigurationConfigDirLongOpt() throws Exception {
        String[] args = new String[]{"--configDir", this.confDir.toFile().getAbsolutePath()};
        List list = FlinkConfigLoader.loadAndModifyConfiguration((String[])args);
        if (this.standardYaml) {
            Assertions.assertThat((List)list).containsExactly((Object[])new String[]{"test:", "  key: test_value"});
        } else {
            Assertions.assertThat((List)list).containsExactly((Object[])new String[]{"test.key: test_value"});
        }
    }

    @TestTemplate
    void testLoadConfigurationConfigDirShortOpt() throws Exception {
        String[] args = new String[]{"-c", this.confDir.toFile().getAbsolutePath()};
        Configuration configuration = FlinkConfigLoader.loadConfiguration((String[])args);
        this.verifyConfiguration(configuration, TEST_CONFIG_KEY, TEST_CONFIG_VALUE);
    }

    @TestTemplate
    void testloadAndModifyConfigurationConfigDirShortOpt() throws Exception {
        String[] args = new String[]{"-c", this.confDir.toFile().getAbsolutePath()};
        List list = FlinkConfigLoader.loadAndModifyConfiguration((String[])args);
        if (this.standardYaml) {
            Assertions.assertThat((List)list).containsExactly((Object[])new String[]{"test:", "  key: test_value"});
        } else {
            Assertions.assertThat((List)list).containsExactly((Object[])new String[]{"test.key: test_value"});
        }
    }

    @TestTemplate
    void testLoadConfigurationDynamicPropertyWithSpace() throws Exception {
        String[] args = new String[]{"--configDir", this.confDir.toFile().getAbsolutePath(), "-D", "key=value"};
        Configuration configuration = FlinkConfigLoader.loadConfiguration((String[])args);
        this.verifyConfiguration(configuration, "key", "value");
    }

    @TestTemplate
    void testloadAndModifyConfigurationDynamicPropertyWithSpace() throws Exception {
        String[] args = new String[]{"--configDir", this.confDir.toFile().getAbsolutePath(), "-D", "key=value"};
        List list = FlinkConfigLoader.loadAndModifyConfiguration((String[])args);
        if (this.standardYaml) {
            Assertions.assertThat((List)list).containsExactly((Object[])new String[]{"test:", "  key: test_value", "key: value"});
        } else {
            Assertions.assertThat((List)list).containsExactlyInAnyOrder((Object[])new String[]{"test.key: test_value", "key: value"});
        }
    }

    @TestTemplate
    void testLoadConfigurationDynamicPropertyWithoutSpace() throws Exception {
        String[] args = new String[]{"--configDir", this.confDir.toFile().getAbsolutePath(), "-Dkey=value"};
        Configuration configuration = FlinkConfigLoader.loadConfiguration((String[])args);
        this.verifyConfiguration(configuration, "key", "value");
    }

    @TestTemplate
    void testloadAndModifyConfigurationDynamicPropertyWithoutSpace() throws Exception {
        String[] args = new String[]{"--configDir", this.confDir.toFile().getAbsolutePath(), "-Dkey=value"};
        List list = FlinkConfigLoader.loadAndModifyConfiguration((String[])args);
        if (this.standardYaml) {
            Assertions.assertThat((List)list).containsExactly((Object[])new String[]{"test:", "  key: test_value", "key: value"});
        } else {
            Assertions.assertThat((List)list).containsExactlyInAnyOrder((Object[])new String[]{"test.key: test_value", "key: value"});
        }
    }

    @TestTemplate
    void testLoadConfigurationIgnoreUnknownToken() throws Exception {
        String[] args = new String[]{"unknown", "-u", "--configDir", this.confDir.toFile().getAbsolutePath(), "--unknown", "-Dkey=value"};
        Configuration configuration = FlinkConfigLoader.loadConfiguration((String[])args);
        this.verifyConfiguration(configuration, TEST_CONFIG_KEY, TEST_CONFIG_VALUE);
        this.verifyConfiguration(configuration, "key", "value");
    }

    @TestTemplate
    void testloadAndModifyConfigurationIgnoreUnknownToken() throws Exception {
        String[] args = new String[]{"unknown", "-u", "--configDir", this.confDir.toFile().getAbsolutePath(), "--unknown", "-Dkey=value"};
        List list = FlinkConfigLoader.loadAndModifyConfiguration((String[])args);
        if (this.standardYaml) {
            Assertions.assertThat((List)list).containsExactly((Object[])new String[]{"test:", "  key: test_value", "key: value"});
        } else {
            Assertions.assertThat((List)list).containsExactlyInAnyOrder((Object[])new String[]{"test.key: test_value", "key: value"});
        }
    }

    @TestTemplate
    void testloadAndModifyConfigurationRemoveKeysMatched() throws Exception {
        String key = "key";
        String[] args = new String[]{"--configDir", this.confDir.toFile().getAbsolutePath(), String.format("-D%s=value", key), "--removeKey", key};
        List list = FlinkConfigLoader.loadAndModifyConfiguration((String[])args);
        if (this.standardYaml) {
            Assertions.assertThat((List)list).containsExactly((Object[])new String[]{"test:", "  key: test_value"});
        } else {
            Assertions.assertThat((List)list).containsExactlyInAnyOrder((Object[])new String[]{"test.key: test_value"});
        }
    }

    @TestTemplate
    void testloadAndModifyConfigurationRemoveKeysNotMatched() throws Exception {
        String key = "key";
        String value = "value";
        String removeKey = "removeKey";
        String[] args = new String[]{"--configDir", this.confDir.toFile().getAbsolutePath(), String.format("-D%s=%s", key, value), "--removeKey", removeKey};
        List list = FlinkConfigLoader.loadAndModifyConfiguration((String[])args);
        if (this.standardYaml) {
            Assertions.assertThat((List)list).containsExactly((Object[])new String[]{"test:", "  key: test_value", key + ": " + value});
        } else {
            Assertions.assertThat((List)list).containsExactlyInAnyOrder((Object[])new String[]{"test.key: test_value", key + ": " + value});
        }
    }

    @TestTemplate
    void testloadAndModifyConfigurationRemoveKeyValuesMatched() throws Exception {
        String removeKey = "removeKey";
        String removeValue = "removeValue";
        String[] args = new String[]{"--configDir", this.confDir.toFile().getAbsolutePath(), String.format("-D%s=%s", removeKey, removeValue), "--removeKeyValue", String.format("%s=%s", removeKey, removeValue)};
        List list = FlinkConfigLoader.loadAndModifyConfiguration((String[])args);
        if (this.standardYaml) {
            Assertions.assertThat((List)list).containsExactly((Object[])new String[]{"test:", "  key: test_value"});
        } else {
            Assertions.assertThat((List)list).containsExactlyInAnyOrder((Object[])new String[]{"test.key: test_value"});
        }
    }

    @TestTemplate
    void testloadAndModifyConfigurationRemoveKeyValuesNotMatched() throws Exception {
        String removeKey = "removeKey";
        String removeValue = "removeValue";
        String nonExistentValue = "nonExistentValue";
        String[] args = new String[]{"--configDir", this.confDir.toFile().getAbsolutePath(), String.format("-D%s=%s", removeKey, removeValue), "--removeKeyValue", String.format("%s=%s", removeKey, nonExistentValue)};
        List list = FlinkConfigLoader.loadAndModifyConfiguration((String[])args);
        if (this.standardYaml) {
            Assertions.assertThat((List)list).containsExactlyInAnyOrder((Object[])new String[]{"test:", "  key: test_value", removeKey + ": " + removeValue});
        } else {
            Assertions.assertThat((List)list).containsExactlyInAnyOrder((Object[])new String[]{"test.key: test_value", removeKey + ": " + removeValue});
        }
    }

    @TestTemplate
    void testloadAndModifyConfigurationReplaceKeyValuesMatched() throws Exception {
        String newValue = "newValue";
        String[] args = new String[]{"--configDir", this.confDir.toFile().getAbsolutePath(), "--replaceKeyValue", String.format("%s,%s,%s", TEST_CONFIG_KEY, TEST_CONFIG_VALUE, newValue)};
        List list = FlinkConfigLoader.loadAndModifyConfiguration((String[])args);
        if (this.standardYaml) {
            Assertions.assertThat((List)list).containsExactly((Object[])new String[]{"test:", "  key: " + newValue});
        } else {
            Assertions.assertThat((List)list).containsExactlyInAnyOrder((Object[])new String[]{"test.key: " + newValue});
        }
    }

    @TestTemplate
    void testloadAndModifyConfigurationReplaceKeyValuesNotMatched() throws Exception {
        String nonExistentValue = "nonExistentValue";
        String newValue = "newValue";
        String[] args = new String[]{"--configDir", this.confDir.toFile().getAbsolutePath(), "--replaceKeyValue", String.format("%s,%s,%s", TEST_CONFIG_KEY, nonExistentValue, newValue)};
        List list = FlinkConfigLoader.loadAndModifyConfiguration((String[])args);
        if (this.standardYaml) {
            Assertions.assertThat((List)list).containsExactly((Object[])new String[]{"test:", "  key: test_value"});
        } else {
            Assertions.assertThat((List)list).containsExactlyInAnyOrder((Object[])new String[]{"test.key: test_value"});
        }
    }

    @TestTemplate
    void testloadAndModifyConfigurationWithFlatten() throws Exception {
        String[] args = new String[]{"-c", this.confDir.toFile().getAbsolutePath(), "-flatten"};
        List list = FlinkConfigLoader.loadAndModifyConfiguration((String[])args);
        Assertions.assertThat((List)list).containsExactly((Object[])new String[]{"test.key: test_value"});
    }

    @Test
    void testMigrateLegacyConfigToStandardYaml() throws Exception {
        try (FileWriter fw = new FileWriter(new File(this.confDir.toFile(), "flink-conf.yaml"));){
            fw.write("test.key: test_value\n");
            fw.write("pipeline.cached-files: name:file1,path:'file:///tmp/file1';name:file2,path:'hdfs:///tmp/file2'\n");
            fw.write("pipeline.default-kryo-serializers: class:org.example.ExampleClass,serializer:org.example.ExampleSerializer1; class:org.example.ExampleClass2,serializer:org.example.ExampleSerializer2\n");
        }
        Configuration configuration = GlobalConfiguration.loadConfiguration((String)this.confDir.toString());
        File newConfigFolder = TempDirUtils.newFolder((Path)this.confDir);
        try (FileWriter fw = new FileWriter(TempDirUtils.newFile((Path)newConfigFolder.toPath(), (String)"config.yaml"));){
            String[] args = new String[]{"-c", this.confDir.toFile().getAbsolutePath()};
            for (String line : FlinkConfigLoader.migrateLegacyConfigurationToStandardYaml((String[])args)) {
                fw.write(line + "\n");
            }
        }
        Configuration standardYamlConfig = GlobalConfiguration.loadConfiguration((String)newConfigFolder.toString());
        Assertions.assertThat((String)configuration.getString(TEST_CONFIG_KEY, null)).isEqualTo(standardYamlConfig.getString(TEST_CONFIG_KEY, null));
        Assertions.assertThat(((List)configuration.get(PipelineOptions.KRYO_DEFAULT_SERIALIZERS)).stream().map(ConfigurationUtils::parseStringToMap).collect(Collectors.toList())).isEqualTo(((List)standardYamlConfig.get(PipelineOptions.KRYO_DEFAULT_SERIALIZERS)).stream().map(ConfigurationUtils::parseStringToMap).collect(Collectors.toList()));
        Assertions.assertThat((List)DistributedCache.parseCachedFilesFromString((List)((List)configuration.get(PipelineOptions.CACHED_FILES)))).isEqualTo((Object)DistributedCache.parseCachedFilesFromString((List)((List)standardYamlConfig.get(PipelineOptions.CACHED_FILES))));
    }

    private void verifyConfiguration(Configuration config, String key, String expectedValue) {
        ConfigOption option = ConfigOptions.key((String)key).stringType().noDefaultValue();
        Assertions.assertThat((String)((String)config.get(option))).isEqualTo(expectedValue);
    }
}

